/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type;

import egovframework.rte.itl.integration.message.typed.TypedList;
import egovframework.rte.itl.integration.type.AbstractType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.integration.type.UnassignableValueException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListType
extends AbstractType {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListType.class);
    protected static final Class<?>[] listTypeAssignableClasses = new Class[]{TypedList.class, Collection.class};
    protected Type elementType = null;

    public ListType() {
    }

    public ListType(String id, String name, Type elementType) {
        super(id, name, listTypeAssignableClasses);
        if (elementType == null) {
            LOGGER.error("Argument 'elementType' is null");
            throw new IllegalArgumentException();
        }
        this.elementType = elementType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public void setElementType(Type elementType) {
        if (elementType == null) {
            LOGGER.error("Argument 'elementType' is null");
            throw new IllegalArgumentException();
        }
        this.elementType = elementType;
    }

    @Override
    public boolean isAssignableFrom(Class<?> clazz) {
        if (super.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isArray()) {
            return this.elementType.isAssignableFrom(clazz.getComponentType());
        }
        return false;
    }

    @Override
    public Object convertToTypedObject(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof TypedList) {
            if (!this.equals(((TypedList)source).getType())) {
                throw new UnassignableValueException();
            }
            return source;
        }
        if (source instanceof Collection) {
            return new TypedList(this, (Collection)source);
        }
        if (source.getClass().isArray()) {
            return new TypedList(this, source);
        }
        throw new UnassignableValueException();
    }

    @Override
    public boolean isAssignableValue(Object source) {
        if (source == null) {
            return true;
        }
        if (source instanceof TypedList) {
            return this.equals(((TypedList)source).getType());
        }
        if (source instanceof Collection) {
            for (Object sourceElement : (Iterable)source) {
                if (this.elementType.isAssignableValue(sourceElement)) continue;
                return false;
            }
            return true;
        }
        if (source.getClass().isArray()) {
            return this.elementType.isAssignableFrom(source.getClass().getComponentType());
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.elementType != null && this.elementType.isValid();
    }
}

