/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type;

import egovframework.rte.itl.integration.message.typed.TypedMap;
import egovframework.rte.itl.integration.type.AbstractType;
import egovframework.rte.itl.integration.type.NoSuchRecordFieldException;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.integration.type.UnassignableValueException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordType
extends AbstractType {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordType.class);
    protected static final Class<?>[] recordTypeAssignableClasses = new Class[]{TypedMap.class, Map.class};
    protected Map<String, Type> fieldTypes = new HashMap<String, Type>();

    public RecordType() {
    }

    public RecordType(String id, String name) {
        super(id, name, recordTypeAssignableClasses);
    }

    public RecordType(String id, String name, Map<String, Type> fieldTypes) {
        super(id, name, recordTypeAssignableClasses);
        if (fieldTypes == null) {
            LOGGER.error("Argument 'fieldTypes' is null");
            throw new IllegalArgumentException();
        }
        this.fieldTypes = fieldTypes;
    }

    public Map<String, Type> getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(Map<String, Type> fieldTypes) {
        if (fieldTypes == null) {
            LOGGER.error("Argument 'fieldTypes' is null");
            throw new IllegalArgumentException();
        }
        this.fieldTypes = fieldTypes;
    }

    public Type getFieldType(String fieldName) {
        Type fieldType = this.fieldTypes.get(fieldName);
        if (fieldType == null) {
            throw new NoSuchRecordFieldException();
        }
        return fieldType;
    }

    @Override
    public Object convertToTypedObject(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof TypedMap) {
            if (!this.equals(((TypedMap)source).getType())) {
                throw new UnassignableValueException();
            }
            return source;
        }
        if (source instanceof Map) {
            for (Map.Entry entry : ((Map)source).entrySet()) {
                if (entry.getKey() instanceof String) continue;
                throw new UnassignableValueException();
            }
            return new TypedMap(this, (Map)source);
        }
        throw new UnassignableValueException();
    }

    @Override
    public boolean isAssignableValue(Object source) {
        if (source == null) {
            return true;
        }
        if (source instanceof TypedMap) {
            return this.equals(((TypedMap)source).getType());
        }
        if (source instanceof Map) {
            for (Map.Entry entry : ((Map)source).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    return false;
                }
                String fieldName = (String)entry.getKey();
                if (this.getFieldType(fieldName).isAssignableValue(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid() || this.fieldTypes == null) {
            return false;
        }
        for (Type fieldType : this.fieldTypes.values()) {
            if (fieldType.isValid()) continue;
            return false;
        }
        return true;
    }
}

