/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.string;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EgovStringUtil {
    private static Log log = LogFactory.getLog(EgovStringUtil.class);
    private static final char WHITE_SPACE = ' ';

    public static boolean isNull(String str) {
        if (str != null) {
            str = str.trim();
        }
        return str == null || "".equals(str);
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int size = str.length();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (!Character.isLetter(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String str) {
        if (str == null) {
            return false;
        }
        int size = str.length();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String integer2string(int integer) {
        return "" + integer;
    }

    public static String long2string(long longdata) {
        return String.valueOf(longdata);
    }

    public static String float2string(float floatdata) {
        return String.valueOf(floatdata);
    }

    public static String double2string(double doubledata) {
        return String.valueOf(doubledata);
    }

    public static String null2void(String str) {
        if (EgovStringUtil.isNull(str)) {
            str = "";
        }
        return str;
    }

    public static int string2integer(String str) {
        if (EgovStringUtil.isNull(str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static float string2float(String str) {
        if (EgovStringUtil.isNull(str)) {
            return 0.0f;
        }
        return Float.parseFloat(str);
    }

    public static double string2double(String str) {
        if (EgovStringUtil.isNull(str)) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static long string2long(String str) {
        if (EgovStringUtil.isNull(str)) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    public static String null2string(String str, String defaultValue) {
        if (EgovStringUtil.isNull(str)) {
            return defaultValue;
        }
        return str;
    }

    public static int string2integer(String str, int defaultValue) {
        if (EgovStringUtil.isNull(str)) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static float string2float(String str, float defaultValue) {
        if (EgovStringUtil.isNull(str)) {
            return defaultValue;
        }
        return Float.parseFloat(str);
    }

    public static double string2double(String str, double defaultValue) {
        if (EgovStringUtil.isNull(str)) {
            return defaultValue;
        }
        return Double.parseDouble(str);
    }

    public static long string2long(String str, long defaultValue) {
        if (EgovStringUtil.isNull(str)) {
            return defaultValue;
        }
        return Long.parseLong(str);
    }

    public static boolean equals(String source, String target) {
        return EgovStringUtil.null2void(source).equals(EgovStringUtil.null2void(target));
    }

    public static String toSubString(String str, int beginIndex, int endIndex) {
        if (EgovStringUtil.equals(str, "")) {
            return str;
        }
        if (str.length() < beginIndex) {
            return "";
        }
        if (str.length() < endIndex) {
            return str.substring(beginIndex);
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String toSubString(String source, int beginIndex) {
        if (EgovStringUtil.equals(source, "")) {
            return source;
        }
        if (source.length() < beginIndex) {
            return "";
        }
        return source.substring(beginIndex);
    }

    public static int search(String source, String target) {
        int result = 0;
        String strCheck = new String(source);
        int i = 0;
        while (i < source.length()) {
            int loc = strCheck.indexOf(target);
            if (loc == -1) break;
            ++result;
            i = loc + target.length();
            strCheck = strCheck.substring(i);
        }
        return result;
    }

    public static String trim(String str) {
        return str.trim();
    }

    public static String ltrim(String str) {
        int index = 0;
        while (' ' == str.charAt(index++)) {
        }
        if (index > 0) {
            str = str.substring(index - 1);
        }
        return str;
    }

    public static String rtrim(String str) {
        int index = str.length();
        while (' ' == str.charAt(--index)) {
        }
        if (index < str.length()) {
            str = str.substring(0, index + 1);
        }
        return str;
    }

    public static String concat(String str1, String str2) {
        StringBuffer sb = new StringBuffer(str1);
        sb.append(str2);
        return sb.toString();
    }

    public static String lPad(String str, int len, char pad) {
        return EgovStringUtil.lPad(str, len, pad, false);
    }

    public static String lPad(String str, int len, char pad, boolean isTrim) {
        if (EgovStringUtil.isNull(str)) {
            return null;
        }
        if (isTrim) {
            str = str.trim();
        }
        int i = str.length();
        while (i < len) {
            str = String.valueOf(pad) + str;
            ++i;
        }
        return str;
    }

    public static String rPad(String str, int len, char pad) {
        return EgovStringUtil.rPad(str, len, pad, false);
    }

    public static String rPad(String str, int len, char pad, boolean isTrim) {
        if (EgovStringUtil.isNull(str)) {
            return null;
        }
        if (isTrim) {
            str = str.trim();
        }
        int i = str.length();
        while (i < len) {
            str = String.valueOf(str) + pad;
            ++i;
        }
        return str;
    }

    public static String alignLeft(String str, int length) {
        return EgovStringUtil.alignLeft(str, length, false);
    }

    public static String alignLeft(String str, int length, boolean isEllipsis) {
        if (str.length() <= length) {
            StringBuffer temp = new StringBuffer(str);
            int i = 0;
            while (i < length - str.length()) {
                temp.append(' ');
                ++i;
            }
            return temp.toString();
        }
        if (isEllipsis) {
            StringBuffer temp = new StringBuffer(length);
            temp.append(str.substring(0, length - 3));
            temp.append("...");
            return temp.toString();
        }
        return str.substring(0, length);
    }

    public static String alignRight(String str, int length) {
        return EgovStringUtil.alignRight(str, length, false);
    }

    public static String alignRight(String str, int length, boolean isEllipsis) {
        if (str.length() <= length) {
            StringBuffer temp = new StringBuffer(length);
            int i = 0;
            while (i < length - str.length()) {
                temp.append(' ');
                ++i;
            }
            temp.append(str);
            return temp.toString();
        }
        if (isEllipsis) {
            StringBuffer temp = new StringBuffer(length);
            temp.append(str.substring(0, length - 3));
            temp.append("...");
            return temp.toString();
        }
        return str.substring(0, length);
    }

    public static String alignCenter(String str, int length) {
        return EgovStringUtil.alignCenter(str, length, false);
    }

    public static String alignCenter(String str, int length, boolean isEllipsis) {
        if (str.length() <= length) {
            StringBuffer temp = new StringBuffer(length);
            int leftMargin = (length - str.length()) / 2;
            int rightMargin = leftMargin * 2 == length - str.length() ? leftMargin : leftMargin + 1;
            int i = 0;
            while (i < leftMargin) {
                temp.append(' ');
                ++i;
            }
            temp.append(str);
            i = 0;
            while (i < rightMargin) {
                temp.append(' ');
                ++i;
            }
            return temp.toString();
        }
        if (isEllipsis) {
            StringBuffer temp = new StringBuffer(length);
            temp.append(str.substring(0, length - 3));
            temp.append("...");
            return temp.toString();
        }
        return str.substring(0, length);
    }

    public static String capitalize(String str) {
        return !EgovStringUtil.isNull(str) ? String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1).toLowerCase() : str;
    }

    public static boolean isPatternMatch(String str, String pattern) throws Exception {
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        log.debug((Object)("" + matcher));
        return matcher.matches();
    }

    public static String toEng(String kor) throws UnsupportedEncodingException {
        if (EgovStringUtil.isNull(kor)) {
            return null;
        }
        return new String(kor.getBytes("KSC5601"), "8859_1");
    }

    public static String toKor(String en) throws UnsupportedEncodingException {
        if (EgovStringUtil.isNull(en)) {
            return null;
        }
        return new String(en.getBytes("8859_1"), "euc-kr");
    }

    public static int countOf(String str, String charToFind) {
        int findLength = charToFind.length();
        int count = 0;
        int idx = str.indexOf(charToFind);
        while (idx >= 0) {
            ++count;
            idx = str.indexOf(charToFind, idx + findLength);
        }
        return count;
    }

    public static String encodePassword(String password, String algorithm) {
        byte[] unencodedPassword = password.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
            return password;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < encodedPassword.length) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
            ++i;
        }
        return buf.toString();
    }

    public static String encodeString(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        return new String(encoder.encodeBuffer(str.getBytes())).trim();
    }

    public static String decodeString(String str) {
        BASE64Decoder dec = new BASE64Decoder();
        try {
            return new String(dec.decodeBuffer(str));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io.getCause());
        }
    }

    public static String swapFirstLetterCase(String str) {
        StringBuffer sbuf = new StringBuffer(str);
        sbuf.deleteCharAt(0);
        if (Character.isLowerCase(str.substring(0, 1).toCharArray()[0])) {
            sbuf.insert(0, str.substring(0, 1).toUpperCase());
        } else {
            sbuf.insert(0, str.substring(0, 1).toLowerCase());
        }
        return sbuf.toString();
    }

    public static String trim(String origString, String trimString) {
        int startPosit = origString.indexOf(trimString);
        if (startPosit != -1) {
            int endPosit = trimString.length() + startPosit;
            return String.valueOf(origString.substring(0, startPosit)) + origString.substring(endPosit);
        }
        return origString;
    }

    public static String getLastString(String origStr, String strToken) {
        StringTokenizer str = new StringTokenizer(origStr, strToken);
        String lastStr = "";
        while (str.hasMoreTokens()) {
            lastStr = str.nextToken();
        }
        return lastStr;
    }

    public static String[] getStringArray(String str, String strToken) {
        if (str.indexOf(strToken) != -1) {
            StringTokenizer st = new StringTokenizer(str, strToken);
            String[] stringArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                stringArray[i] = st.nextToken();
                ++i;
            }
            return stringArray;
        }
        return new String[]{str};
    }

    public static boolean isNotEmpty(String str) {
        return !EgovStringUtil.isEmpty(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replace(String str, String replacedStr, String replaceStr) {
        String newStr = "";
        if (str.indexOf(replacedStr) != -1) {
            String s1 = str.substring(0, str.indexOf(replacedStr));
            String s2 = str.substring(str.indexOf(replacedStr) + 1);
            newStr = String.valueOf(s1) + replaceStr + s2;
        }
        return newStr;
    }

    public static boolean isPatternMatching(String str, String pattern) throws Exception {
        if (pattern.indexOf(42) >= 0) {
            pattern = pattern.replaceAll("\\*", ".*");
        }
        pattern = "^" + pattern + "$";
        return Pattern.matches(pattern, str);
    }

    public static boolean containsMaxSequence(String str, String maxSeqNumber) {
        int occurence = 1;
        int max = EgovStringUtil.string2integer(maxSeqNumber);
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz - 1) {
            if (str.charAt(i) == str.charAt(i + 1)) {
                if (++occurence == max) {
                    return true;
                }
            } else {
                occurence = 1;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsInvalidChars(String str, char[] invalidChars) {
        if (str == null || invalidChars == null) {
            return false;
        }
        int strSize = str.length();
        int validSize = invalidChars.length;
        int i = 0;
        while (i < strSize) {
            char ch = str.charAt(i);
            int j = 0;
            while (j < validSize) {
                if (invalidChars[j] == ch) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsInvalidChars(String str, String invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        return EgovStringUtil.containsInvalidChars(str, invalidChars.toCharArray());
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        int i = 0;
        while (i < sz) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuffer(str).reverse().toString();
    }

    public static String fillString(String originalStr, char ch, int cipers) {
        int originalStrLength = originalStr.length();
        if (cipers < originalStrLength) {
            return null;
        }
        int difference = cipers - originalStrLength;
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (i < difference) {
            strBuf.append(ch);
            ++i;
        }
        strBuf.append(originalStr);
        return strBuf.toString();
    }

    public static final boolean isEmptyTrimmed(String foo) {
        return foo == null || foo.trim().length() == 0;
    }

    public static List getTokens(String lst, String separator) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (lst != null) {
            StringTokenizer st = new StringTokenizer(lst, separator);
            while (st.hasMoreTokens()) {
                try {
                    String en = st.nextToken().trim();
                    tokens.add(en);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tokens;
    }

    public static List getTokens(String lst) {
        return EgovStringUtil.getTokens(lst, ",");
    }

    public static String convertToCamelCase(String targetString, char posChar) {
        StringBuffer result = new StringBuffer();
        boolean nextUpper = false;
        String allLower = targetString.toLowerCase();
        int i = 0;
        while (i < allLower.length()) {
            char currentChar = allLower.charAt(i);
            if (currentChar == posChar) {
                nextUpper = true;
            } else {
                if (nextUpper) {
                    currentChar = Character.toUpperCase(currentChar);
                    nextUpper = false;
                }
                result.append(currentChar);
            }
            ++i;
        }
        return result.toString();
    }

    public static String convertToCamelCase(String underScore) {
        return EgovStringUtil.convertToCamelCase(underScore, '_');
    }

    public static String convertToUnderScore(String camelCase) {
        String result = "";
        int i = 0;
        while (i < camelCase.length()) {
            char currentChar = camelCase.charAt(i);
            if (i > 0 && Character.isUpperCase(currentChar)) {
                result = result.concat("_");
            }
            result = result.concat(Character.toString(currentChar).toLowerCase());
            ++i;
        }
        return result;
    }
}

