/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.listener;

import org.apache.commons.io.FilenameUtils;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ExecutionContext;

public class EgovOutputFileListener {
    private String outputKeyName = "outputFile";
    private String inputKeyName = "fileName";
    private String path = "file:./target/output/";

    public void setPath(String path) {
        this.path = path;
    }

    public void setOutputKeyName(String outputKeyName) {
        this.outputKeyName = outputKeyName;
    }

    public void setInputKeyName(String inputKeyName) {
        this.inputKeyName = inputKeyName;
    }

    @BeforeStep
    public void createOutputNameFromInput(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        String inputName = stepExecution.getStepName().replace(":", "-");
        if (executionContext.containsKey(this.inputKeyName)) {
            inputName = executionContext.getString(this.inputKeyName);
        }
        if (!executionContext.containsKey(this.outputKeyName)) {
            executionContext.putString(this.outputKeyName, this.path + FilenameUtils.getBaseName((String)inputName) + ".csv");
        }
    }
}

