/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;

public class ChainableIOException
extends IOException
implements Cloneable {
    static final Comparator PRIORITY_COMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            int cmp = ((ChainableIOException)o1).getPriority() - ((ChainableIOException)o2).getPriority();
            return cmp != 0 ? cmp : APPEARANCE_COMP.compare(o1, o2);
        }
    };
    static final Comparator APPEARANCE_COMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ChainableIOException)o1).getAppearance() - ((ChainableIOException)o2).getAppearance();
        }
    };
    private static int maxPrintExceptions = 3;
    private ChainableIOException prior;
    private final int appearance;
    int maxAppearance;

    public ChainableIOException(ChainableIOException priorException) {
        this(priorException, null, null);
    }

    public ChainableIOException(ChainableIOException priorException, String message) {
        this(priorException, message, null);
    }

    public ChainableIOException(ChainableIOException priorException, IOException cause) {
        this(priorException, null, cause);
    }

    public ChainableIOException(ChainableIOException priorException, String message, IOException cause) {
        super(message);
        this.prior = priorException;
        if (cause != null) {
            this.initCause(cause);
        }
        this.maxAppearance = priorException != null ? priorException.maxAppearance + 1 : 0;
        this.appearance = this.maxAppearance;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public int getPriority() {
        return 0;
    }

    public final int getAppearance() {
        return this.appearance;
    }

    public ChainableIOException getPrior() {
        return this.prior;
    }

    public ChainableIOException sortPriority() {
        return this.sort(PRIORITY_COMP);
    }

    public ChainableIOException sortAppearance() {
        return this.sort(APPEARANCE_COMP);
    }

    private ChainableIOException sort(Comparator comp) {
        if (this.prior != null) {
            ChainableIOException sortedPrior = this.prior.sort(comp);
            if (sortedPrior == this.prior && comp.compare(this, this.prior) >= 0) {
                return this;
            }
            return sortedPrior.insert((ChainableIOException)this.clone(), comp);
        }
        return this;
    }

    private ChainableIOException insert(ChainableIOException element, Comparator comp) {
        if (comp.compare(element, this) >= 0) {
            element.prior = this;
            element.maxAppearance = Math.max(element.appearance, this.maxAppearance);
            return element;
        }
        ChainableIOException clone = (ChainableIOException)this.clone();
        if (this.prior != null) {
            clone.prior = this.prior.insert(element, comp);
            clone.maxAppearance = Math.max(clone.appearance, clone.prior.maxAppearance);
        } else {
            element.prior = null;
            clone.prior = element;
            clone.maxAppearance = element.maxAppearance;
        }
        return clone;
    }

    public final Throwable initCause(Throwable cause) {
        return this.initCause((IOException)cause);
    }

    public Throwable initCause(IOException cause) {
        return super.initCause(cause);
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(s, ChainableIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintStream s, int maxExceptions) {
        --maxExceptions;
        if (this.prior != null) {
            if (maxExceptions > 0) {
                this.prior.printStackTrace(s, maxExceptions);
                s.println("Followed, but not caused by:");
            } else {
                s.println("(Omitting " + this.prior.getNumExceptions() + " exception(s) at the start of this list)");
            }
        }
        super.printStackTrace(s);
    }

    private int getNumExceptions() {
        return this.prior != null ? this.prior.getNumExceptions() + 1 : 1;
    }

    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(s, ChainableIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintWriter s, int maxExceptions) {
        --maxExceptions;
        if (this.prior != null) {
            if (maxExceptions > 0) {
                this.prior.printStackTrace(s, maxExceptions);
                s.println("Followed, but not caused by:");
            } else {
                s.println("(Omitting " + this.prior.getNumExceptions() + " exception(s) at the start of this list)");
            }
        }
        super.printStackTrace(s);
    }

    public static int getMaxPrintExceptions() {
        return maxPrintExceptions;
    }

    public static void setMaxPrintExceptions(int maxPrintExcepions) {
        maxPrintExceptions = maxPrintExcepions;
    }
}

