/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.format.registry.DefaultFormatterRegistry;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.config.FlowBuilderInfo;
import org.springframework.webflow.config.FlowElementAttribute;
import org.springframework.webflow.config.FlowLocation;
import org.springframework.webflow.expression.DefaultExpressionParserFactory;
import org.w3c.dom.Element;

class FlowRegistryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    FlowRegistryBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.config.FlowRegistryFactoryBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        String flowBuilderServices = element.getAttribute("flow-builder-services");
        if (StringUtils.hasText((String)flowBuilderServices)) {
            definitionBuilder.addPropertyReference("flowBuilderServices", flowBuilderServices);
        } else {
            definitionBuilder.addPropertyValue("flowBuilderServices", (Object)this.createDefaultFlowBuilderServices(parserContext));
        }
        String parent = element.getAttribute("parent");
        if (StringUtils.hasText((String)parent)) {
            definitionBuilder.addPropertyReference("parent", parent);
        }
        definitionBuilder.addPropertyValue("flowLocations", (Object)this.parseLocations(element));
        definitionBuilder.addPropertyValue("flowLocationPatterns", (Object)this.parseLocationPatterns(element));
        definitionBuilder.addPropertyValue("flowBuilders", (Object)this.parseFlowBuilders(element));
    }

    private List parseLocations(Element element) {
        List locationElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-location");
        if (locationElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FlowLocation> locations = new ArrayList<FlowLocation>(locationElements.size());
        Iterator it = locationElements.iterator();
        while (it.hasNext()) {
            Element locationElement = (Element)it.next();
            String id = locationElement.getAttribute("id");
            String path = locationElement.getAttribute("path");
            locations.add(new FlowLocation(id, path, this.parseAttributes(locationElement)));
        }
        return locations;
    }

    private List parseLocationPatterns(Element element) {
        List locationPatternElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-location-pattern");
        if (locationPatternElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> locationPatterns = new ArrayList<String>(locationPatternElements.size());
        Iterator it = locationPatternElements.iterator();
        while (it.hasNext()) {
            Element locationPatternElement = (Element)it.next();
            String value = locationPatternElement.getAttribute("value");
            locationPatterns.add(value);
        }
        return locationPatterns;
    }

    private Set parseAttributes(Element element) {
        Element definitionAttributesElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-definition-attributes");
        if (definitionAttributesElement != null) {
            List attributeElements = DomUtils.getChildElementsByTagName((Element)definitionAttributesElement, (String)"attribute");
            HashSet<FlowElementAttribute> attributes = new HashSet<FlowElementAttribute>(attributeElements.size());
            Iterator it = attributeElements.iterator();
            while (it.hasNext()) {
                Element attributeElement = (Element)it.next();
                String name = attributeElement.getAttribute("name");
                String value = attributeElement.getAttribute("value");
                String type = attributeElement.getAttribute("type");
                attributes.add(new FlowElementAttribute(name, value, type));
            }
            return attributes;
        }
        return null;
    }

    private List parseFlowBuilders(Element element) {
        List builderElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-builder");
        if (builderElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FlowBuilderInfo> builders = new ArrayList<FlowBuilderInfo>(builderElements.size());
        Iterator it = builderElements.iterator();
        while (it.hasNext()) {
            Element builderElement = (Element)it.next();
            String id = builderElement.getAttribute("id");
            String className = builderElement.getAttribute("class");
            builders.add(new FlowBuilderInfo(id, className, this.parseAttributes(builderElement)));
        }
        return builders;
    }

    private BeanDefinition createDefaultFlowBuilderServices(ParserContext context) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.springframework.webflow.engine.builder.support.FlowBuilderServices");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeanDefinitionBuilder defaultBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz);
        defaultBuilder.addPropertyValue("formatterRegistry", (Object)DefaultFormatterRegistry.getSharedInstance());
        defaultBuilder.addPropertyValue("conversionService", (Object)DefaultConversionService.getSharedInstance());
        defaultBuilder.addPropertyValue("expressionParser", (Object)DefaultExpressionParserFactory.getExpressionParser());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.springframework.webflow.mvc.builder.MvcViewFactoryCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        defaultBuilder.addPropertyValue("viewFactoryCreator", (Object)BeanDefinitionBuilder.genericBeanDefinition((Class)clazz2).getBeanDefinition());
        return defaultBuilder.getBeanDefinition();
    }
}

