/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderException;

public class DefaultFlowHolder
implements FlowDefinitionHolder {
    private static final Log logger;
    private FlowDefinition flowDefinition;
    private FlowAssembler assembler;
    private boolean assembling;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.builder.DefaultFlowHolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public DefaultFlowHolder(FlowAssembler assembler) {
        this.assembler = assembler;
    }

    public String getFlowDefinitionId() {
        return this.assembler.getFlowBuilderContext().getFlowId();
    }

    public synchronized FlowDefinition getFlowDefinition() throws FlowDefinitionConstructionException {
        if (this.assembling) {
            return this.getFlowBuilder().getFlow();
        }
        if (this.flowDefinition == null) {
            logger.debug((Object)"Assembling the flow for the first time");
            this.assembleFlow();
        } else if (this.getFlowBuilder().hasFlowChanged()) {
            logger.debug((Object)"The flow has changed; reassembling...");
            this.assembleFlow();
        }
        return this.flowDefinition;
    }

    public synchronized void refresh() throws FlowDefinitionConstructionException {
        this.assembleFlow();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void assembleFlow() throws FlowDefinitionConstructionException {
        try {
            try {
                this.assembling = true;
                this.flowDefinition = this.assembler.assembleFlow();
            }
            catch (FlowBuilderException e) {
                throw new FlowDefinitionConstructionException(this.assembler.getFlowBuilderContext().getFlowId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.assembling = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.assembling = false;
            return;
        }
    }

    private FlowBuilder getFlowBuilder() {
        return this.assembler.getFlowBuilder();
    }

    public String toString() {
        return "'" + this.getFlowDefinitionId() + "'";
    }
}

