/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.Iterator;
import java.util.LinkedList;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.ActionStateModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.BeanImportModel;
import org.springframework.webflow.engine.model.DecisionStateModel;
import org.springframework.webflow.engine.model.EndStateModel;
import org.springframework.webflow.engine.model.ExceptionHandlerModel;
import org.springframework.webflow.engine.model.InputModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.OutputModel;
import org.springframework.webflow.engine.model.PersistenceContextModel;
import org.springframework.webflow.engine.model.SecuredModel;
import org.springframework.webflow.engine.model.SubflowStateModel;
import org.springframework.webflow.engine.model.TransitionModel;
import org.springframework.webflow.engine.model.VarModel;
import org.springframework.webflow.engine.model.ViewStateModel;

public class FlowModel
extends AbstractModel {
    private String abztract;
    private String parent;
    private String startStateId;
    private LinkedList attributes;
    private SecuredModel secured;
    private PersistenceContextModel persistenceContext;
    private LinkedList vars;
    private LinkedList inputs;
    private LinkedList outputs;
    private LinkedList onStartActions;
    private LinkedList states;
    private LinkedList globalTransitions;
    private LinkedList onEndActions;
    private LinkedList exceptionHandlers;
    private LinkedList beanImports;

    public boolean isMergeableWith(Model model) {
        return model instanceof FlowModel;
    }

    public void merge(Model model) {
        FlowModel flow = (FlowModel)model;
        this.setParent(null);
        this.setStartStateId(this.merge(this.getStartStateId(), flow.getStartStateId()));
        this.setAttributes(this.merge(this.getAttributes(), flow.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), flow.getSecured()));
        this.setPersistenceContext((PersistenceContextModel)this.merge(this.getPersistenceContext(), flow.getPersistenceContext()));
        this.setVars(this.merge(this.getVars(), flow.getVars(), false));
        this.setInputs(this.merge(this.getInputs(), flow.getInputs()));
        this.setOutputs(this.merge(this.getOutputs(), flow.getOutputs()));
        this.setOnStartActions(this.merge(this.getOnStartActions(), flow.getOnStartActions(), false));
        this.setStates(this.merge(this.getStates(), flow.getStates()));
        this.setGlobalTransitions(this.merge(this.getGlobalTransitions(), flow.getGlobalTransitions()));
        this.setOnEndActions(this.merge(this.getOnEndActions(), flow.getOnEndActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), flow.getExceptionHandlers()));
        this.setBeanImports(this.merge(this.getBeanImports(), flow.getBeanImports()));
    }

    public String getAbstract() {
        return this.abztract;
    }

    public void setAbstract(String abztract) {
        this.abztract = StringUtils.hasText((String)abztract) ? abztract : null;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = StringUtils.hasText((String)parent) ? parent : null;
    }

    public String getStartStateId() {
        return this.startStateId;
    }

    public void setStartStateId(String startStateId) {
        this.startStateId = StringUtils.hasText((String)startStateId) ? startStateId : null;
    }

    public void setStartState(AbstractStateModel startState) {
        this.setStartStateId(startState.getId());
    }

    public LinkedList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(AttributeModel attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.add(attribute);
    }

    public void addAttributes(LinkedList attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.addAll(attributes);
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public PersistenceContextModel getPersistenceContext() {
        return this.persistenceContext;
    }

    public void setPersistenceContext(PersistenceContextModel persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public LinkedList getVars() {
        return this.vars;
    }

    public void setVars(LinkedList vars) {
        this.vars = vars;
    }

    public void addVar(VarModel var) {
        if (var == null) {
            return;
        }
        if (this.vars == null) {
            this.vars = new LinkedList();
        }
        this.vars.add(var);
    }

    public void addVars(LinkedList vars) {
        if (vars == null || vars.isEmpty()) {
            return;
        }
        if (this.vars == null) {
            this.vars = new LinkedList();
        }
        this.vars.addAll(vars);
    }

    public LinkedList getInputs() {
        return this.inputs;
    }

    public void setInputs(LinkedList inputs) {
        this.inputs = inputs;
    }

    public void addInput(InputModel input) {
        if (input == null) {
            return;
        }
        if (this.inputs == null) {
            this.inputs = new LinkedList();
        }
        this.inputs.add(input);
    }

    public void addInputs(LinkedList inputs) {
        if (inputs == null || inputs.isEmpty()) {
            return;
        }
        if (this.inputs == null) {
            this.inputs = new LinkedList();
        }
        this.inputs.addAll(inputs);
    }

    public LinkedList getOutputs() {
        return this.outputs;
    }

    public void setOutputs(LinkedList outputs) {
        this.outputs = outputs;
    }

    public void addOutput(OutputModel output) {
        if (output == null) {
            return;
        }
        if (this.outputs == null) {
            this.outputs = new LinkedList();
        }
        this.outputs.add(output);
    }

    public void addOutputs(LinkedList outputs) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        if (this.outputs == null) {
            this.outputs = new LinkedList();
        }
        this.outputs.addAll(outputs);
    }

    public LinkedList getOnStartActions() {
        return this.onStartActions;
    }

    public void setOnStartActions(LinkedList onStartActions) {
        this.onStartActions = onStartActions;
    }

    public void addOnStartAction(AbstractActionModel onStartAction) {
        if (onStartAction == null) {
            return;
        }
        if (this.onStartActions == null) {
            this.onStartActions = new LinkedList();
        }
        this.onStartActions.add(onStartAction);
    }

    public void addOnStartActions(LinkedList onStartActions) {
        if (onStartActions == null || onStartActions.isEmpty()) {
            return;
        }
        if (this.onStartActions == null) {
            this.onStartActions = new LinkedList();
        }
        this.onStartActions.addAll(onStartActions);
    }

    public LinkedList getStates() {
        return this.states;
    }

    public AbstractStateModel getStateById(String id) {
        if (this.states != null) {
            Iterator it = this.states.iterator();
            while (it.hasNext()) {
                AbstractStateModel state = (AbstractStateModel)it.next();
                if (!id.equals(state.getId())) continue;
                return state;
            }
        }
        return null;
    }

    public void setStates(LinkedList states) {
        this.states = states;
    }

    public void addState(AbstractStateModel state) {
        if (state == null) {
            return;
        }
        if (this.states == null) {
            this.states = new LinkedList();
        }
        this.states.add(state);
    }

    public void addStates(LinkedList states) {
        if (states == null || states.isEmpty()) {
            return;
        }
        if (this.states == null) {
            this.states = new LinkedList();
        }
        this.states.addAll(states);
    }

    public void addActionState(ActionStateModel state) {
        this.addState(state);
    }

    public void addActionStates(LinkedList states) {
        this.addStates(states);
    }

    public void addViewState(ViewStateModel state) {
        this.addState(state);
    }

    public void addViewStates(LinkedList states) {
        this.addStates(states);
    }

    public void addDecisionState(DecisionStateModel state) {
        this.addState(state);
    }

    public void addDecisionStates(LinkedList states) {
        this.addStates(states);
    }

    public void addSubflowState(SubflowStateModel state) {
        this.addState(state);
    }

    public void addSubflowStates(LinkedList states) {
        this.addStates(states);
    }

    public void addEndState(EndStateModel state) {
        this.addState(state);
    }

    public void addEndStates(LinkedList states) {
        this.addStates(states);
    }

    public LinkedList getGlobalTransitions() {
        return this.globalTransitions;
    }

    public void setGlobalTransitions(LinkedList globalTransitions) {
        this.globalTransitions = globalTransitions;
    }

    public void addGlobalTransition(TransitionModel globalTransition) {
        if (globalTransition == null) {
            return;
        }
        if (this.globalTransitions == null) {
            this.globalTransitions = new LinkedList();
        }
        this.globalTransitions.add(globalTransition);
    }

    public void addGlobalTransitions(LinkedList globalTransitions) {
        if (globalTransitions == null || globalTransitions.isEmpty()) {
            return;
        }
        if (this.globalTransitions == null) {
            this.globalTransitions = new LinkedList();
        }
        this.globalTransitions.addAll(globalTransitions);
    }

    public LinkedList getOnEndActions() {
        return this.onEndActions;
    }

    public void setOnEndActions(LinkedList onEndActions) {
        this.onEndActions = onEndActions;
    }

    public void addOnEndAction(AbstractActionModel onEndAction) {
        if (onEndAction == null) {
            return;
        }
        if (this.onEndActions == null) {
            this.onEndActions = new LinkedList();
        }
        this.onEndActions.add(onEndAction);
    }

    public void addOnEndActions(LinkedList onEndActions) {
        if (onEndActions == null || onEndActions.isEmpty()) {
            return;
        }
        if (this.onEndActions == null) {
            this.onEndActions = new LinkedList();
        }
        this.onEndActions.addAll(onEndActions);
    }

    public LinkedList getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(LinkedList exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public void addExceptionHandler(ExceptionHandlerModel exceptionHandler) {
        if (exceptionHandler == null) {
            return;
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new LinkedList();
        }
        this.exceptionHandlers.add(exceptionHandler);
    }

    public void addExceptionHandlers(LinkedList exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.isEmpty()) {
            return;
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new LinkedList();
        }
        this.exceptionHandlers.addAll(exceptionHandlers);
    }

    public LinkedList getBeanImports() {
        return this.beanImports;
    }

    public void setBeanImports(LinkedList beanImports) {
        this.beanImports = beanImports;
    }

    public void addBeanImport(BeanImportModel beanImport) {
        if (beanImport == null) {
            return;
        }
        if (this.beanImports == null) {
            this.beanImports = new LinkedList();
        }
        this.beanImports.add(beanImport);
    }

    public void addBeanImports(LinkedList beanImports) {
        if (beanImports == null || beanImports.isEmpty()) {
            return;
        }
        if (this.beanImports == null) {
            this.beanImports = new LinkedList();
        }
        this.beanImports.addAll(beanImports);
    }
}

