/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class EventIdTransitionCriteria
implements TransitionCriteria,
Serializable {
    private String eventId;
    private boolean caseSensitive = true;

    public EventIdTransitionCriteria(String eventId) {
        Assert.hasText((String)eventId, (String)"The event id is required");
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean test(RequestContext context) {
        Event lastEvent = context.getCurrentEvent();
        if (lastEvent == null) {
            return false;
        }
        if (this.caseSensitive) {
            return this.eventId.equals(lastEvent.getId());
        }
        return this.eventId.equalsIgnoreCase(lastEvent.getId());
    }

    public String toString() {
        return "[eventId = '" + this.eventId + "']";
    }
}

