/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.webflow.execution.repository.impl.FlowExecutionSnapshotGroup;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.SnapshotNotFoundException;

class SimpleFlowExecutionSnapshotGroup
implements FlowExecutionSnapshotGroup,
Serializable {
    private Map snapshots = new HashMap();
    private LinkedList snapshotIds = new LinkedList();
    private int maxSnapshots = -1;

    SimpleFlowExecutionSnapshotGroup() {
    }

    public int getMaxSnapshots() {
        return this.maxSnapshots;
    }

    public void setMaxSnapshots(int maxSnapshots) {
        this.maxSnapshots = maxSnapshots;
    }

    public FlowExecutionSnapshot getSnapshot(Serializable snapshotId) throws SnapshotNotFoundException {
        FlowExecutionSnapshot snapshot = (FlowExecutionSnapshot)this.snapshots.get(snapshotId);
        if (snapshot == null) {
            throw new SnapshotNotFoundException(snapshotId);
        }
        return snapshot;
    }

    public void addSnapshot(Serializable snapshotId, FlowExecutionSnapshot snapshot) {
        this.snapshots.put(snapshotId, snapshot);
        if (this.snapshotIds.contains(snapshotId)) {
            this.snapshotIds.remove(snapshotId);
        }
        this.snapshotIds.add(snapshotId);
        if (this.maxExceeded()) {
            this.removeOldestSnapshot();
        }
    }

    public void updateSnapshot(Serializable snapshotId, FlowExecutionSnapshot snapshot) throws SnapshotNotFoundException {
        if (!this.snapshots.containsKey(snapshotId)) {
            throw new SnapshotNotFoundException(snapshotId);
        }
        this.snapshots.put(snapshotId, snapshot);
    }

    public void removeSnapshot(Serializable snapshotId) {
        this.snapshots.remove(snapshotId);
        this.snapshotIds.remove(snapshotId);
    }

    public void removeAllSnapshots() {
        this.snapshots.clear();
        this.snapshotIds.clear();
    }

    public int getSnapshotCount() {
        return this.snapshotIds.size();
    }

    private boolean maxExceeded() {
        return this.maxSnapshots > 0 && this.snapshotIds.size() > this.maxSnapshots;
    }

    private void removeOldestSnapshot() {
        this.snapshots.remove(this.snapshotIds.removeFirst());
    }
}

