/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;

public abstract class AbstractSnapshottingFlowExecutionRepository
extends AbstractFlowExecutionRepository {
    private FlowExecutionSnapshotFactory executionSnapshotFactory;

    public AbstractSnapshottingFlowExecutionRepository(ConversationManager conversationManager, FlowExecutionStateRestorer executionStateRestorer, FlowExecutionSnapshotFactory executionSnapshotFactory) {
        super(conversationManager, executionStateRestorer);
        Assert.notNull((Object)executionSnapshotFactory, (String)"The flow execution snapshot factory is required");
        this.executionSnapshotFactory = executionSnapshotFactory;
    }

    public FlowExecutionSnapshotFactory getExecutionSnapshotFactory() {
        return this.executionSnapshotFactory;
    }

    protected Serializable getSnapshotId(FlowExecutionKey key) {
        return ((CompositeFlowExecutionKey)key).getSnapshotId();
    }

    protected FlowExecutionSnapshot snapshot(FlowExecution flowExecution) {
        return this.executionSnapshotFactory.createSnapshot(flowExecution);
    }

    protected FlowExecution deserializeExecution(byte[] snapshotBytes) {
        return this.executionSnapshotFactory.restoreSnapshot(snapshotBytes).unmarshal();
    }
}

