/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.SnapshotCreationException;
import org.springframework.webflow.execution.repository.snapshot.SnapshotUnmarshalException;

public class SerializedFlowExecutionSnapshotFactory
implements FlowExecutionSnapshotFactory {
    private boolean compress = true;

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public FlowExecutionSnapshot createSnapshot(FlowExecution flowExecution) throws SnapshotCreationException {
        return new SerializedFlowExecutionSnapshot(flowExecution, this.compress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowExecutionSnapshot restoreSnapshot(byte[] bytes) throws SnapshotUnmarshalException {
        try {
            FlowExecutionSnapshot flowExecutionSnapshot;
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            try {
                flowExecutionSnapshot = (FlowExecutionSnapshot)ois.readObject();
                Object var3_6 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                ois.close();
                throw throwable;
            }
            ois.close();
            return flowExecutionSnapshot;
        }
        catch (IOException e) {
            throw new SnapshotUnmarshalException("IO problem while creating the flow execution snapshot", e);
        }
        catch (ClassNotFoundException e) {
            throw new SnapshotUnmarshalException("Class not found while creating the flow execution snapshot", e);
        }
    }
}

