/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;
import org.springframework.webflow.execution.repository.support.ConversationBackedFlowExecutionLock;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;

public abstract class AbstractFlowExecutionRepository
implements FlowExecutionRepository,
FlowExecutionKeyFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final Integer ONE = new Integer(1);
    private ConversationManager conversationManager;
    private FlowExecutionStateRestorer executionStateRestorer;
    private boolean alwaysGenerateNewNextKey = true;

    protected AbstractFlowExecutionRepository(ConversationManager conversationManager, FlowExecutionStateRestorer executionStateRestorer) {
        Assert.notNull((Object)conversationManager, (String)"The conversation manager is required");
        Assert.notNull((Object)executionStateRestorer, (String)"The execution state restorer is required");
        this.conversationManager = conversationManager;
        this.executionStateRestorer = executionStateRestorer;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public FlowExecutionStateRestorer getExecutionStateRestorer() {
        return this.executionStateRestorer;
    }

    public boolean getAlwaysGenerateNewNextKey() {
        return this.alwaysGenerateNewNextKey;
    }

    public void setAlwaysGenerateNewNextKey(boolean alwaysGenerateNewNextKey) {
        this.alwaysGenerateNewNextKey = alwaysGenerateNewNextKey;
    }

    public FlowExecutionKey getKey(FlowExecution execution) {
        if (execution.getKey() == null) {
            Conversation conversation = this.beginConversation(execution);
            return new CompositeFlowExecutionKey(conversation.getId(), ONE);
        }
        return this.getNextKey(execution);
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        if (!StringUtils.hasText((String)encodedKey)) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, "The string-encoded flow execution key is required");
        }
        String[] keyParts = CompositeFlowExecutionKey.keyParts(encodedKey);
        ConversationId executionId = this.parseExecutionId(keyParts[0], encodedKey);
        Serializable snapshotId = this.parseSnapshotId(keyParts[1], encodedKey);
        return new CompositeFlowExecutionKey(executionId, snapshotId);
    }

    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return new ConversationBackedFlowExecutionLock(this.getConversation(key));
    }

    public abstract FlowExecution getFlowExecution(FlowExecutionKey var1) throws FlowExecutionRepositoryException;

    public abstract void putFlowExecution(FlowExecution var1) throws FlowExecutionRepositoryException;

    public void removeFlowExecution(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
        this.assertKeySet(flowExecution);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing flow execution '" + flowExecution + "' from repository"));
        }
        this.endConversation(flowExecution);
    }

    protected ConversationParameters createConversationParameters(FlowExecution flowExecution) {
        FlowDefinition flow = flowExecution.getDefinition();
        return new ConversationParameters(flow.getId(), flow.getCaption(), flow.getDescription());
    }

    protected FlowExecutionKey getNextKey(FlowExecution execution) {
        if (this.alwaysGenerateNewNextKey) {
            CompositeFlowExecutionKey currentKey = (CompositeFlowExecutionKey)execution.getKey();
            Integer currentSnapshotId = (Integer)currentKey.getSnapshotId();
            return new CompositeFlowExecutionKey(currentKey.getExecutionId(), this.nextSnapshotId(currentSnapshotId));
        }
        return execution.getKey();
    }

    protected Conversation getConversation(FlowExecutionKey key) throws NoSuchFlowExecutionException {
        try {
            ConversationId conversationId = (ConversationId)((CompositeFlowExecutionKey)key).getExecutionId();
            return this.conversationManager.getConversation(conversationId);
        }
        catch (NoSuchConversationException e) {
            throw new NoSuchFlowExecutionException(key, e);
        }
    }

    protected FlowExecution restoreTransientState(FlowExecution execution, FlowExecutionKey key, Conversation conversation) {
        MutableAttributeMap conversationScope = (MutableAttributeMap)conversation.getAttribute("scope");
        return this.executionStateRestorer.restoreState(execution, key, conversationScope, this);
    }

    protected void putConversationScope(FlowExecution flowExecution, Conversation conversation) {
        conversation.putAttribute("scope", flowExecution.getConversationScope());
    }

    protected void assertKeySet(FlowExecution execution) throws IllegalStateException {
        if (execution.getKey() == null) {
            throw new IllegalStateException("The key for the flow execution is null; make sure the key is assigned first.  Execution Details = " + execution);
        }
    }

    private Conversation beginConversation(FlowExecution execution) {
        ConversationParameters parameters = this.createConversationParameters(execution);
        Conversation conversation = this.conversationManager.beginConversation(parameters);
        return conversation;
    }

    private Integer nextSnapshotId(Integer currentSnapshotId) {
        if (JdkVersion.isAtLeastJava15()) {
            return currentSnapshotId + 1;
        }
        return new Integer(currentSnapshotId + 1);
    }

    private ConversationId parseExecutionId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return this.conversationManager.parseConversationId(encodedId);
        }
        catch (ConversationException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), e);
        }
    }

    private Serializable parseSnapshotId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return Integer.valueOf(encodedId);
        }
        catch (NumberFormatException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), e);
        }
    }

    private Conversation endConversation(FlowExecution flowExecution) {
        Conversation conversation = this.getConversation(flowExecution.getKey());
        conversation.end();
        return conversation;
    }
}

