/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;

public class FlowExecutorImpl
implements FlowExecutor {
    private FlowDefinitionLocator definitionLocator;
    private FlowExecutionFactory executionFactory;
    private FlowExecutionRepository executionRepository;

    public FlowExecutorImpl(FlowDefinitionLocator definitionLocator, FlowExecutionFactory executionFactory, FlowExecutionRepository executionRepository) {
        Assert.notNull((Object)definitionLocator, (String)"The locator for accessing flow definitions is required");
        Assert.notNull((Object)executionFactory, (String)"The execution factory for creating new flow executions is required");
        Assert.notNull((Object)executionRepository, (String)"The repository for persisting flow executions is required");
        this.definitionLocator = definitionLocator;
        this.executionFactory = executionFactory;
        this.executionRepository = executionRepository;
    }

    public FlowDefinitionLocator getDefinitionLocator() {
        return this.definitionLocator;
    }

    public FlowExecutionFactory getExecutionFactory() {
        return this.executionFactory;
    }

    public FlowExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    public FlowExecutionResult launchExecution(String flowId, MutableAttributeMap input, ExternalContext context) throws FlowException {
        FlowExecution flowExecution;
        block3: {
            FlowExecutionResult flowExecutionResult;
            try {
                ExternalContextHolder.setExternalContext(context);
                FlowDefinition flowDefinition = this.definitionLocator.getFlowDefinition(flowId);
                flowExecution = this.executionFactory.createFlowExecution(flowDefinition);
                flowExecution.start(input, context);
                if (flowExecution.hasEnded()) break block3;
                this.executionRepository.putFlowExecution(flowExecution);
                flowExecutionResult = this.createPausedResult(flowExecution);
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                ExternalContextHolder.setExternalContext(null);
                throw throwable;
            }
            ExternalContextHolder.setExternalContext(null);
            return flowExecutionResult;
        }
        FlowExecutionResult flowExecutionResult = this.createEndResult(flowExecution);
        Object var6_9 = null;
        ExternalContextHolder.setExternalContext(null);
        return flowExecutionResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowExecutionResult resumeExecution(String flowExecutionKey, ExternalContext context) throws FlowException {
        try {
            FlowExecution flowExecution;
            FlowExecutionLock lock;
            block5: {
                FlowExecutionResult flowExecutionResult;
                ExternalContextHolder.setExternalContext(context);
                FlowExecutionKey key = this.executionRepository.parseFlowExecutionKey(flowExecutionKey);
                lock = this.executionRepository.getLock(key);
                lock.lock();
                try {
                    flowExecution = this.executionRepository.getFlowExecution(key);
                    flowExecution.resume(context);
                    if (flowExecution.hasEnded()) break block5;
                    this.executionRepository.putFlowExecution(flowExecution);
                    flowExecutionResult = this.createPausedResult(flowExecution);
                    Object var6_8 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var9_11 = null;
                ExternalContextHolder.setExternalContext(null);
                return flowExecutionResult;
            }
            this.executionRepository.removeFlowExecution(flowExecution);
            FlowExecutionResult flowExecutionResult = this.createEndResult(flowExecution);
            Object var6_9 = null;
            lock.unlock();
            Object var9_12 = null;
            ExternalContextHolder.setExternalContext(null);
            return flowExecutionResult;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            ExternalContextHolder.setExternalContext(null);
            throw throwable;
        }
    }

    private FlowExecutionResult createEndResult(FlowExecution flowExecution) {
        return FlowExecutionResult.createEndedResult(flowExecution.getDefinition().getId(), flowExecution.getOutcome());
    }

    private FlowExecutionResult createPausedResult(FlowExecution flowExecution) {
        return FlowExecutionResult.createPausedResult(flowExecution.getDefinition().getId(), flowExecution.getKey().toString());
    }
}

