/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression;

import javax.el.ExpressionFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.el.DefaultExpressionFactoryUtils;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.expression.WebFlowOgnlExpressionParser;
import org.springframework.webflow.expression.el.WebFlowELExpressionParser;

public final class DefaultExpressionParserFactory {
    private static ExpressionParser INSTANCE;

    private DefaultExpressionParserFactory() {
    }

    public static synchronized ExpressionParser getExpressionParser() {
        return new ExpressionParser(){

            public Expression parseExpression(String expressionString, ParserContext context) throws ParserException {
                return DefaultExpressionParserFactory.getDefaultExpressionParser().parseExpression(expressionString, context);
            }
        };
    }

    private static synchronized ExpressionParser getDefaultExpressionParser() {
        if (INSTANCE == null) {
            INSTANCE = DefaultExpressionParserFactory.createDefaultExpressionParser();
        }
        return INSTANCE;
    }

    private static ExpressionParser createDefaultExpressionParser() throws IllegalStateException {
        try {
            ExpressionFactory elFactory = DefaultExpressionFactoryUtils.createExpressionFactory();
            return new WebFlowELExpressionParser(elFactory);
        }
        catch (Exception exception) {
            try {
                ClassUtils.forName((String)"ognl.Ognl");
                return new WebFlowOgnlExpressionParser();
            }
            catch (ClassNotFoundException ex) {
                IllegalStateException ise = new IllegalStateException("Unable to create the default expression parser for Spring Web Flow: Neither a Unified EL implementation or OGNL could be found.");
                ise.initCause(ex);
                throw ise;
            }
            catch (NoClassDefFoundError ex) {
                IllegalStateException ise = new IllegalStateException("Unable to create the default expression parser for Spring Web Flow: Neither a Unified EL implementation or OGNL could be found.");
                ise.initCause(ex);
                throw ise;
            }
        }
    }
}

