/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import org.springframework.binding.collection.SharedMap;
import org.springframework.binding.collection.SharedMapDecorator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.test.MockParameterMap;

public class MockExternalContext
implements ExternalContext {
    private String contextPath;
    private ParameterMap requestParameterMap = new MockParameterMap();
    private MutableAttributeMap requestMap = new LocalAttributeMap();
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap globalSessionMap = this.sessionMap = new LocalSharedAttributeMap((SharedMap)new SharedMapDecorator(new HashMap()));
    private SharedAttributeMap applicationMap = new LocalSharedAttributeMap((SharedMap)new SharedMapDecorator(new HashMap()));
    private Object nativeContext = new Object();
    private Object nativeRequest = new Object();
    private Object nativeResponse = new Object();
    private Principal currentUser;
    private Locale locale;
    private StringWriter responseWriter = new StringWriter();
    private boolean ajaxRequest;
    private boolean flowExecutionRedirectRequested;
    private String flowDefinitionRedirectFlowId;
    private MutableAttributeMap flowDefinitionRedirectFlowInput;
    private String externalRedirectUrl;
    private boolean redirectInPopup;

    public MockExternalContext() {
    }

    public MockExternalContext(ParameterMap requestParameterMap) {
        if (requestParameterMap != null) {
            this.requestParameterMap = requestParameterMap;
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.globalSessionMap;
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public Principal getCurrentUser() {
        return this.currentUser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getNativeContext() {
        return this.nativeContext;
    }

    public Object getNativeRequest() {
        return this.nativeRequest;
    }

    public Object getNativeResponse() {
        return this.nativeResponse;
    }

    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    public String getFlowExecutionUrl(String flowId, String flowExecutionKey) {
        return "/" + flowId + "?execution=" + flowExecutionKey;
    }

    public Writer getResponseWriter() {
        return this.responseWriter;
    }

    public boolean isResponseCommitted() {
        return this.getFlowExecutionRedirectRequested() || this.getFlowDefinitionRedirectRequested() || this.getExternalRedirectRequested();
    }

    public boolean isResponseAllowed() {
        return true;
    }

    public void requestFlowExecutionRedirect() {
        this.flowExecutionRedirectRequested = true;
    }

    public void requestFlowDefinitionRedirect(String flowId, MutableAttributeMap input) {
        this.flowDefinitionRedirectFlowId = flowId;
        this.flowDefinitionRedirectFlowInput = input;
    }

    public void requestExternalRedirect(String uri) {
        this.externalRedirectUrl = uri;
    }

    public void requestRedirectInPopup() {
        this.redirectInPopup = true;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setRequestParameterMap(ParameterMap requestParameterMap) {
        this.requestParameterMap = requestParameterMap;
    }

    public void setRequestMap(MutableAttributeMap requestMap) {
        this.requestMap = requestMap;
    }

    public void setSessionMap(SharedAttributeMap sessionMap) {
        this.sessionMap = sessionMap;
    }

    public void setGlobalSessionMap(SharedAttributeMap globalSessionMap) {
        this.globalSessionMap = globalSessionMap;
    }

    public void setApplicationMap(SharedAttributeMap applicationMap) {
        this.applicationMap = applicationMap;
    }

    public void setNativeContext(Object nativeContext) {
        this.nativeContext = nativeContext;
    }

    public void setNativeRequest(Object nativeRequest) {
        this.nativeRequest = nativeRequest;
    }

    public void setNativeResponse(Object nativeResponse) {
        this.nativeResponse = nativeResponse;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = new MockPrincipal(currentUser);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public MockParameterMap getMockRequestParameterMap() {
        return (MockParameterMap)this.requestParameterMap;
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockRequestParameterMap().put(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockRequestParameterMap().put(parameterName, parameterValues);
    }

    public void setEventId(String eventId) {
        this.putRequestParameter("_eventId", eventId);
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public StringWriter getMockResponseWriter() {
        return this.responseWriter;
    }

    public boolean getFlowExecutionRedirectRequested() {
        return this.flowExecutionRedirectRequested;
    }

    public boolean getFlowDefinitionRedirectRequested() {
        return this.flowDefinitionRedirectFlowId != null;
    }

    public String getFlowRedirectFlowId() {
        return this.flowDefinitionRedirectFlowId;
    }

    public MutableAttributeMap getFlowRedirectFlowInput() {
        return this.flowDefinitionRedirectFlowInput;
    }

    public boolean getExternalRedirectRequested() {
        return this.externalRedirectUrl != null;
    }

    public String getExternalRedirectUrl() {
        return this.externalRedirectUrl;
    }

    public boolean getRedirectInPopup() {
        return this.redirectInPopup;
    }

    private class MockPrincipal
    implements Principal {
        private String name;

        private MockPrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

