/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test.execution;

import junit.framework.TestCase;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.test.MockExternalContext;

public abstract class AbstractFlowExecutionTests
extends TestCase {
    private FlowExecutionFactory flowExecutionFactory;
    private FlowExecution flowExecution;
    private FlowExecutionOutcome flowExecutionOutcome;

    public AbstractFlowExecutionTests() {
    }

    public AbstractFlowExecutionTests(String name) {
        super(name);
    }

    protected FlowExecutionFactory getFlowExecutionFactory() {
        if (this.flowExecutionFactory == null) {
            this.flowExecutionFactory = this.createFlowExecutionFactory();
        }
        return this.flowExecutionFactory;
    }

    protected void startFlow(ExternalContext context) throws FlowExecutionException {
        this.startFlow(null, context);
    }

    protected void startFlow(MutableAttributeMap input, ExternalContext context) throws FlowExecutionException {
        this.flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        this.flowExecution.start(input, context);
        if (this.flowExecution.hasEnded()) {
            this.flowExecutionOutcome = this.flowExecution.getOutcome();
        }
    }

    protected void resumeFlow(ExternalContext context) throws FlowExecutionException {
        Assert.state((this.flowExecution != null ? 1 : 0) != 0, (String)"The flow execution to test is [null]; you must start the flow execution before you can resume it!");
        this.flowExecution.resume(context);
        if (this.flowExecution.hasEnded()) {
            this.flowExecutionOutcome = this.flowExecution.getOutcome();
        }
    }

    protected void setCurrentState(String stateId) {
        if (this.flowExecution == null) {
            this.flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        }
        ((FlowExecutionImpl)this.flowExecution).setCurrentState(stateId);
    }

    protected FlowExecution getFlowExecution() throws IllegalStateException {
        return this.flowExecution;
    }

    protected FlowExecutionOutcome getFlowExecutionOutcome() {
        return this.flowExecutionOutcome;
    }

    protected MutableAttributeMap getViewScope() throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getViewScope();
    }

    protected MutableAttributeMap getFlowScope() throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getScope();
    }

    protected MutableAttributeMap getConversationScope() throws IllegalStateException {
        return this.getFlowExecution().getConversationScope();
    }

    protected Object getViewAttribute(String attributeName) {
        return this.getFlowExecution().getActiveSession().getViewScope().get(attributeName);
    }

    protected Object getRequiredViewAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getViewScope().getRequired(attributeName);
    }

    protected Object getRequiredViewAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getViewScope().getRequired(attributeName, requiredType);
    }

    protected Object getFlowAttribute(String attributeName) {
        return this.getFlowExecution().getActiveSession().getScope().get(attributeName);
    }

    protected Object getRequiredFlowAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getScope().getRequired(attributeName);
    }

    protected Object getRequiredFlowAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getScope().getRequired(attributeName, requiredType);
    }

    protected Object getConversationAttribute(String attributeName) {
        return this.getFlowExecution().getConversationScope().get(attributeName);
    }

    protected Object getRequiredConversationAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecution().getConversationScope().getRequired(attributeName);
    }

    protected Object getRequiredConversationAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecution().getConversationScope().getRequired(attributeName, requiredType);
    }

    protected void assertFlowExecutionActive() {
        AbstractFlowExecutionTests.assertTrue((String)"The flow execution is not active but it should be", (boolean)this.getFlowExecution().isActive());
    }

    protected void assertActiveFlowEquals(String expectedActiveFlowId) {
        AbstractFlowExecutionTests.assertEquals((String)("The active flow id '" + this.getFlowExecution().getActiveSession().getDefinition().getId() + "' does not equal the expected active flow id '" + expectedActiveFlowId + "'"), (String)expectedActiveFlowId, (String)this.getFlowExecution().getActiveSession().getDefinition().getId());
    }

    protected void assertFlowExecutionEnded() {
        AbstractFlowExecutionTests.assertTrue((String)"The flow execution is still active but it should have ended", (boolean)this.getFlowExecution().hasEnded());
    }

    protected void assertFlowExecutionOutcomeEquals(String outcome) {
        AbstractFlowExecutionTests.assertNotNull((String)"There has been no flow execution outcome", (Object)this.flowExecutionOutcome);
        AbstractFlowExecutionTests.assertEquals((String)"The flow execution outcome is wrong", (String)this.flowExecutionOutcome.getId(), (String)outcome);
    }

    protected void assertCurrentStateEquals(String expectedCurrentStateId) {
        AbstractFlowExecutionTests.assertEquals((String)("The current state '" + this.getFlowExecution().getActiveSession().getState().getId() + "' does not equal the expected state '" + expectedCurrentStateId + "'"), (String)expectedCurrentStateId, (String)this.getFlowExecution().getActiveSession().getState().getId());
    }

    protected void assertResponseWrittenEquals(String response, MockExternalContext context) {
        AbstractFlowExecutionTests.assertEquals((String)response, (String)context.getMockResponseWriter().getBuffer().toString());
    }

    protected FlowExecutionFactory createFlowExecutionFactory() {
        return new FlowExecutionImplFactory();
    }

    protected void updateFlowExecution(FlowExecution flowExecution) {
        this.flowExecution = flowExecution;
    }

    protected abstract FlowDefinition getFlowDefinition();
}

