/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.metadata.IntegrationDefinition;
import egovframework.rte.itl.integration.metadata.OrganizationDefinition;
import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.metadata.SystemDefinition;
import egovframework.rte.itl.integration.support.AbstractService;
import egovframework.rte.itl.webservice.EgovWebServiceMessage;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.service.EgovWebServiceClient;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgovWebService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovWebService.class);
    private final IntegrationDefinition integrationDefinition;
    private final EgovWebServiceMessageHeader defaultHeader;
    private EgovWebServiceClient client;

    public EgovWebService(String id, long defaultTimeout, IntegrationDefinition integrationDefinition, EgovWebServiceClient client) {
        super(id, defaultTimeout);
        if (integrationDefinition == null) {
            LOGGER.error("integrationDefinition is null");
            throw new IllegalArgumentException();
        }
        if (!integrationDefinition.isValid()) {
            LOGGER.error("integrationDefinition is invalid");
            throw new IllegalArgumentException();
        }
        if (!id.equals(integrationDefinition.getId())) {
            LOGGER.error("id not equals to integrationDefinition's id");
            throw new IllegalArgumentException();
        }
        if (client == null) {
            LOGGER.error("client is null");
            throw new IllegalArgumentException();
        }
        this.integrationDefinition = integrationDefinition;
        this.client = client;
        ServiceDefinition providerService = integrationDefinition.getProvider();
        SystemDefinition providerSystem = providerService.getSystem();
        OrganizationDefinition providerOrganization = providerSystem.getOrganization();
        SystemDefinition consumerSystem = integrationDefinition.getConsumer();
        OrganizationDefinition consumerOrganization = consumerSystem.getOrganization();
        this.defaultHeader = new EgovWebServiceMessageHeader(id, providerOrganization.getId(), providerSystem.getId(), providerService.getId(), consumerOrganization.getId(), consumerSystem.getId(), null, null, null, null, EgovIntegrationMessageHeader.ResultCode.OK, null);
    }

    public EgovIntegrationMessage createRequestMessage() {
        return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader));
    }

    protected EgovIntegrationMessage doSend(EgovIntegrationMessage requestMessage) {
        LOGGER.debug("EgovWebSerivce doSend (requestMessage = {})", (Object)requestMessage);
        if (!this.integrationDefinition.isUsing()) {
            LOGGER.info("Integration (id = \"{}\") is not usable", (Object)this.id);
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.NOT_USABLE_INTEGRATION);
                }
            });
        }
        boolean validFrom = true;
        boolean validTo = true;
        Calendar now = Calendar.getInstance();
        if (this.integrationDefinition.getValidateFrom() != null) {
            boolean bl = validFrom = this.integrationDefinition.getValidateFrom().compareTo(now) <= 0;
        }
        if (this.integrationDefinition.getValidateTo() != null) {
            boolean bl = validTo = now.compareTo(this.integrationDefinition.getValidateTo()) <= 0;
        }
        if (!validFrom || !validTo) {
            LOGGER.info("Integration (id = \"{}\") is invalid at {} (validFrom = {}, validTo = {})", new Object[]{this.id, now, this.integrationDefinition.getValidateFrom(), this.integrationDefinition.getValidateTo()});
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.INVALID_TIME);
                }
            });
        }
        if (!this.integrationDefinition.getProvider().isUsing()) {
            LOGGER.info("Integration (id = \"{}\")'s provider service is not usable", (Object)this.id);
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.NOT_USABLE_SERVICE);
                }
            });
        }
        requestMessage.getHeader().setRequestSendTime(now);
        EgovIntegrationMessage responseMessage = this.client.service(requestMessage);
        responseMessage.getHeader().setResponseReceiveTime(Calendar.getInstance());
        return responseMessage;
    }
}

