/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.facets;

import java.util.Enumeration;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SchemaException;

public final class MinExclusive
extends Facet {
    private static final long serialVersionUID = 9164023814934394681L;

    public MinExclusive(String value) {
        super("minExclusive", value);
    }

    public boolean overridesBase(Facet baseFacet) {
        String otherName = baseFacet.getName();
        return otherName.equals("minExclusive") || otherName.equals("minInclusive");
    }

    public void checkConstraints(Enumeration localFacets, Enumeration baseFacets) throws SchemaException {
        String otherName;
        Facet other;
        while (localFacets.hasMoreElements()) {
            other = (Facet)localFacets.nextElement();
            if (this == other) continue;
            otherName = other.getName();
            if (otherName.equals("minInclusive")) {
                throw new SchemaException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if (!otherName.equals("maxInclusive") || !this.getOwningType().isNumericType() || this.toBigDecimal().compareTo(other.toBigDecimal()) < 0) continue;
            throw new SchemaException("It is an error for the value specified for minExclusive to be greater than or equal to the value specified for maxInclusive for the same datatype.");
        }
        if (baseFacets != null) {
            while (baseFacets.hasMoreElements()) {
                other = (Facet)baseFacets.nextElement();
                otherName = other.getName();
                if (otherName.equals("minExclusive") && this.getOwningType().isNumericType() && this.toBigDecimal().compareTo(other.toBigDecimal()) < 0) {
                    throw new SchemaException("It is an error if the following condition is true: minExclusive is among the members of {facets} of {base type definition} and {value} is less than the {value} of the parent minExclusive.");
                }
                if (otherName.equals("maxInclusive") && this.getOwningType().isNumericType() && this.toBigDecimal().compareTo(other.toBigDecimal()) > 0) {
                    throw new SchemaException("It is an error if the following condition is true: maxInclusive is among the members of {facets} of {base type definition} and {value} is greater than the {value} of the parent maxInclusive.");
                }
                if (otherName.equals("minInclusive") && this.getOwningType().isNumericType() && this.toBigDecimal().compareTo(other.toBigDecimal()) < 0) {
                    throw new SchemaException("It is an error if the following condition is true: minInclusive is among the members of {facets} of {base type definition} and {value} is less than the {value} of the parent minInclusive.");
                }
                if (!otherName.equals("maxExclusive") || !this.getOwningType().isNumericType() || this.toBigDecimal().compareTo(other.toBigDecimal()) < 0) continue;
                throw new SchemaException("It is an error if the following condition is true: maxExclusive is among the members of {facets} of {base type definition} and {value} is greater than or equal to the {value} of the parent maxExclusive.");
            }
        }
    }
}

