/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.support;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.EgovIntegrationServiceResponse;
import egovframework.rte.itl.integration.message.simple.SimpleMessage;
import egovframework.rte.itl.integration.message.simple.SimpleMessageHeader;
import egovframework.rte.itl.integration.support.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultResponse
implements EgovIntegrationServiceResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponse.class);
    protected MessageSender sender;
    protected long defaultTimeout;

    public DefaultResponse(MessageSender sender, long defaultTimeout) {
        this.sender = sender;
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public EgovIntegrationMessage receive() {
        LOGGER.debug("receive without timeout. Call receive with defaultTimeout");
        return this.receive(this.defaultTimeout);
    }

    @Override
    public EgovIntegrationMessage receive(long timeout) {
        LOGGER.debug("receive with timeout");
        LOGGER.debug("wait for the termination of MessageSender");
        try {
            this.sender.join(timeout);
        }
        catch (InterruptedException e) {
            LOGGER.debug("MessageSender was interrupted", (Throwable)e);
        }
        if (this.sender.isAlive()) {
            LOGGER.debug("MessageSender is alive over 'timeout'");
            this.sender.interrupt();
            SimpleMessageHeader responseHeader = new SimpleMessageHeader(this.sender.requestMessage.getHeader());
            responseHeader.setResultCode(EgovIntegrationMessageHeader.ResultCode.TIME_OUT);
            return new SimpleMessage(responseHeader);
        }
        LOGGER.debug("MessageSender finished to send and receive messages.");
        return this.sender.getResponseMessage();
    }
}

