/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type;

import egovframework.rte.itl.integration.type.AbstractType;
import egovframework.rte.itl.integration.type.UnassignableValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PrimitiveType
extends AbstractType {
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", "boolean", new Class[]{Boolean.TYPE, Boolean.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return (Boolean)source;
        }
    };
    public static final PrimitiveType STRING = new PrimitiveType("string", "string", new Class[]{String.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return (String)source;
        }
    };
    public static final PrimitiveType BYTE = new PrimitiveType("byte", "byte", new Class[]{Byte.TYPE, Byte.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return ((Number)source).byteValue();
        }
    };
    public static final PrimitiveType SHORT = new PrimitiveType("short", "short", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return ((Number)source).shortValue();
        }
    };
    public static final PrimitiveType INTEGER = new PrimitiveType("integer", "integer", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return ((Number)source).intValue();
        }
    };
    public static final PrimitiveType LONG = new PrimitiveType("long", "long", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return ((Number)source).longValue();
        }
    };
    public static final PrimitiveType BIGINTEGER = new PrimitiveType("biginteger", "biginteger", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            if (source instanceof BigInteger) {
                return source;
            }
            return BigInteger.valueOf(((Number)source).longValue());
        }
    };
    public static final PrimitiveType FLOAT = new PrimitiveType("float", "float", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Float.TYPE, Float.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return Float.valueOf(((Number)source).floatValue());
        }
    };
    public static final PrimitiveType DOUBLE = new PrimitiveType("double", "double", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Float.TYPE, Float.class, Double.TYPE, Double.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            return ((Number)source).doubleValue();
        }
    };
    public static final PrimitiveType BIGDECIMAL = new PrimitiveType("bigdecimal", "bigdecimal", new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            if (source instanceof BigDecimal) {
                return source;
            }
            if (source instanceof BigInteger) {
                return new BigDecimal((BigInteger)source);
            }
            if (BIGINTEGER.isAssignableValue(source)) {
                return new BigDecimal((BigInteger)BIGINTEGER.convertToTypedObject(source));
            }
            return BigDecimal.valueOf(((Number)source).doubleValue());
        }
    };
    public static final PrimitiveType CALENDAR = new PrimitiveType("calendar", "calendar", new Class[]{Date.class, Calendar.class}){

        @Override
        public Object convertToTypedObject(Object source) {
            if (source == null) {
                return null;
            }
            if (!this.isAssignableFrom(source.getClass())) {
                throw new UnassignableValueException();
            }
            if (source instanceof Date) {
                Calendar value = Calendar.getInstance();
                value.setTime((Date)source);
                return value;
            }
            return source;
        }
    };
    protected static final Map<String, PrimitiveType> primitiveTypes = new HashMap<String, PrimitiveType>(){
        private static final long serialVersionUID = -5126785475742494349L;
        {
            this.putType(BOOLEAN);
            this.putType(STRING);
            this.putType(BYTE);
            this.putType(SHORT);
            this.putType(INTEGER);
            this.putType(LONG);
            this.putType(BIGINTEGER);
            this.putType(FLOAT);
            this.putType(DOUBLE);
            this.putType(BIGDECIMAL);
            this.putType(CALENDAR);
        }

        private void putType(PrimitiveType type) {
            this.put(type.getId(), type);
        }
    };

    protected PrimitiveType() {
    }

    protected PrimitiveType(String id, String name, Class<?>[] assignableClasses) {
        super(id, name, assignableClasses);
    }

    protected PrimitiveType(String id, String name, List<Class<?>> assignableClasses) {
        super(id, name, assignableClasses);
    }

    @Override
    public boolean isAssignableValue(Object source) {
        if (source == null) {
            return true;
        }
        return this.isAssignableFrom(source.getClass());
    }

    public static PrimitiveType getPrimitiveType(String id) {
        return primitiveTypes.get(id);
    }
}

