/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.excel.util;

import egovframework.rte.fdl.string.EgovDateUtil;
import egovframework.rte.fdl.string.EgovStringUtil;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgovExcelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovExcelUtil.class);

    public static String getValue(Cell cell) {
        String result = "";
        if (cell == null || cell.equals(null)) {
            return "";
        }
        if (cell.getCellType() == 4) {
            LOGGER.debug("### Cell.CELL_TYPE_BOOLEAN : {}", (Object)4);
            result = String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == 5) {
            LOGGER.debug("### Cell.CELL_TYPE_ERROR : {}", (Object)5);
        } else if (cell.getCellType() == 2) {
            LOGGER.debug("### Cell.CELL_TYPE_FORMULA : {}", (Object)2);
            String stringValue = cell.getRichStringCellValue().getString();
            String longValue = EgovExcelUtil.doubleToString(cell.getNumericCellValue());
            result = EgovStringUtil.isNumeric((String)longValue) ? longValue : stringValue;
        } else if (cell.getCellType() == 0) {
            LOGGER.debug("### Cell.CELL_TYPE_NUMERIC : {}", (Object)0);
            result = DateUtil.isCellDateFormatted((Cell)cell) ? EgovDateUtil.toString((Date)cell.getDateCellValue(), (String)"yyyy/MM/dd", null) : EgovExcelUtil.doubleToString(cell.getNumericCellValue());
        } else if (cell.getCellType() == 1) {
            LOGGER.debug("### Cell.CELL_TYPE_STRING : {}", (Object)1);
            result = cell.getRichStringCellValue().getString();
        } else if (cell.getCellType() == 3) {
            LOGGER.debug("### Cell.CELL_TYPE_BLANK : {}", (Object)3);
        }
        return result;
    }

    public static String doubleToString(double d) {
        long lValue = (long)d;
        return (double)lValue == d ? Long.toString(lValue) : Double.toString(d);
    }
}

