/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata;

import egovframework.rte.itl.integration.metadata.OrganizationDefinition;
import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemDefinition
implements Validatable {
    private String key;
    private OrganizationDefinition organization;
    private String id;
    private String name;
    private boolean standard;
    private Map<String, ServiceDefinition> services = new HashMap<String, ServiceDefinition>();
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public SystemDefinition() {
    }

    public SystemDefinition(String key, OrganizationDefinition organization, String id, String name, boolean standard) {
        this.key = key;
        this.organization = organization;
        this.id = id;
        this.name = name;
        this.standard = standard;
        this.statusChanged.set(true);
    }

    public SystemDefinition(String key, OrganizationDefinition organization, String id, String name, boolean standard, Map<String, ServiceDefinition> services) {
        this.key = key;
        this.organization = organization;
        this.id = id;
        this.name = name;
        this.standard = standard;
        this.services = services;
        this.statusChanged.set(true);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.statusChanged.set(true);
    }

    public OrganizationDefinition getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationDefinition organization) {
        this.organization = organization;
        this.statusChanged.set(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.statusChanged.set(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.statusChanged.set(true);
    }

    public boolean isStandard() {
        return this.standard;
    }

    public void setStandard(boolean standard) {
        this.standard = standard;
    }

    public Map<String, ServiceDefinition> getServices() {
        return this.services;
    }

    public void setServices(Map<String, ServiceDefinition> services) {
        this.services = services;
        this.statusChanged.set(true);
    }

    public ServiceDefinition getServiceDefinition(String serviceId) {
        return this.services.get(serviceId);
    }

    @Override
    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.key) && this.organization != null && StringUtils.hasText((String)this.id) && StringUtils.hasText((String)this.name) && this.services != null;
            if (this.organization != null) {
                boolean bl2 = this.valid = this.valid && this.organization.isValid();
            }
            if (this.services != null) {
                for (ServiceDefinition service : this.services.values()) {
                    this.valid = this.valid && service.isValid();
                }
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tkey = ").append(StringUtils.quote((String)this.key));
        if (this.organization == null) {
            sb.append("\n\torganization = null");
        } else {
            sb.append("\n\torganization.id = ").append(StringUtils.quote((String)this.organization.getId()));
        }
        sb.append("\n\tid = ").append(StringUtils.quote((String)this.id)).append("\n\tname = ").append(StringUtils.quote((String)this.name)).append("\n\tstandard = ").append(this.standard);
        if (this.services == null) {
            sb.append("\n\tservices = null");
        } else {
            sb.append("\n\tservices = {");
            for (Map.Entry<String, ServiceDefinition> entry : this.services.entrySet()) {
                sb.append("\n\t\t<key = ").append(StringUtils.quote((String)entry.getKey())).append(", value = ").append(entry.getValue() == null ? "" : "\n").append(entry.getValue()).append(">");
            }
            sb.append("\n\t}");
        }
        sb.append("\n}");
        return sb.toString();
    }
}

