/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.logging.db;

import egovframework.rte.fdl.logging.db.SingletonDataSourceProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.MDC;
import org.apache.log4j.db.DBHelper;
import org.apache.log4j.jdbc.JDBCAppender;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.springframework.stereotype.Component;

@Component(value="egovJDBCAppender")
public class EgovJDBCAppender
extends JDBCAppender {
    boolean locationInfo = false;
    private final SingletonDataSourceProvider provider = SingletonDataSourceProvider.getInstance();

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.provider.setDataSource(dataSource);
    }

    protected void closeConnection(Connection con) {
        try {
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.provider.getDataSource().getConnection();
    }

    protected void execute(String sql) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                con = this.getConnection();
                con.setAutoCommit(true);
                stmt = con.createStatement();
                stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            stmt.close();
            this.closeConnection(con);
        }
    }

    public void append(LoggingEvent event) {
        MDC.put((String)"sequence_number", (Object)event.getSequenceNumber());
        MDC.put((String)"timestamp", (Object)event.getTimeStamp());
        MDC.put((String)"rendered_message", (String)event.getRenderedMessage());
        MDC.put((String)"logger_name", (String)event.getLoggerName());
        MDC.put((String)"level_string", (String)event.getLevel().toString());
        String ndc = event.getNDC();
        if (ndc != null) {
            MDC.put((String)"ndc", (String)ndc);
        }
        MDC.put((String)"thread_name", (String)event.getThreadName());
        MDC.put((String)"reference_flag", (Object)DBHelper.computeReferenceMask((LoggingEvent)event));
        LocationInfo li = event.locationInformationExists() || this.locationInfo ? event.getLocationInformation() : LocationInfo.NA_LOCATION_INFO;
        MDC.put((String)"caller_filename", (String)li.getFileName());
        MDC.put((String)"caller_class", (String)li.getClassName());
        MDC.put((String)"caller_method", (String)li.getMethodName());
        MDC.put((String)"caller_line", (String)li.getLineNumber());
        super.append(event);
    }

    public boolean isLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public SingletonDataSourceProvider getProvider() {
        return this.provider;
    }
}

