/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.userdetails.util;

import egovframework.rte.fdl.security.userdetails.EgovUserDetails;
import egovframework.rte.fdl.string.EgovObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovUserDetailsHelper {
    private static Log log = LogFactory.getLog(EgovUserDetailsHelper.class);

    public static Object getAuthenticatedUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (EgovObjectUtil.isNull((Object)authentication)) {
            log.debug((Object)"## authentication object is null!!");
            return null;
        }
        EgovUserDetails details = (EgovUserDetails)((Object)authentication.getPrincipal());
        log.debug((Object)("## EgovUserDetailsHelper.getAuthenticatedUser : AuthenticatedUser is " + details.getUsername()));
        return details.getEgovUserVO();
    }

    public static List<String> getAuthorities() {
        ArrayList<String> listAuth = new ArrayList<String>();
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (EgovObjectUtil.isNull((Object)authentication)) {
            log.debug((Object)"## authentication object is null!!");
            return null;
        }
        GrantedAuthority[] authorities = authentication.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            listAuth.add(authorities[i].getAuthority());
            log.debug((Object)("## EgovUserDetailsHelper.getAuthorities : Authority is " + authorities[i].getAuthority()));
        }
        return listAuth;
    }

    public static Boolean isAuthenticated() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (EgovObjectUtil.isNull((Object)authentication)) {
            log.debug((Object)"## authentication object is null!!");
            return Boolean.FALSE;
        }
        String username = authentication.getName();
        if (username.equals("roleAnonymous")) {
            log.debug((Object)("## username is " + username));
            return Boolean.FALSE;
        }
        Object principal = authentication.getPrincipal();
        return !EgovObjectUtil.isNull((Object)principal);
    }
}

