/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.registry;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.FormatterRegistry;
import org.springframework.util.Assert;

public class GenericFormatterRegistry
implements FormatterRegistry {
    private Map formattersById = new HashMap();
    private Map formattersByClass = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    public Formatter getFormatter(Class clazz) {
        Assert.notNull((Object)clazz, (String)"The formatted class argument is required");
        clazz = this.convertToWrapperClassIfNecessary(clazz);
        return this.findFormatter(clazz);
    }

    public Formatter getFormatter(String id) {
        Assert.hasText((String)id, (String)"The id of the custom formatter is required");
        return (Formatter)this.formattersById.get(id);
    }

    public void registerFormatter(Class clazz, Formatter formatter) {
        Assert.notNull((Object)formatter, (String)"The formatter to register is required");
        this.formattersByClass.put(clazz, formatter);
    }

    public void registerFormatter(String id, Formatter formatter) {
        Assert.hasText((String)id, (String)"The id of the custom formatter is required");
        Assert.notNull((Object)formatter, (String)"The formatter to register is required");
        this.formattersById.put(id, formatter);
    }

    private Formatter findFormatter(Class clazz) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(clazz);
        while (!classQueue.isEmpty()) {
            clazz = (Class)classQueue.removeLast();
            Formatter factory = (Formatter)this.formattersByClass.get(clazz);
            if (factory != null) {
                return factory;
            }
            if (!clazz.isInterface() && clazz.getSuperclass() != null) {
                classQueue.add(clazz.getSuperclass());
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                classQueue.addFirst(interfaces[i]);
                ++i;
            }
        }
        return null;
    }

    private Class convertToWrapperClassIfNecessary(Class targetType) {
        if (targetType.isPrimitive()) {
            if (targetType.equals(Integer.TYPE)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Short.TYPE)) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Long.TYPE)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Float.TYPE)) {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Double.TYPE)) {
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Byte.TYPE)) {
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = class$11 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Boolean.TYPE)) {
                Class<?> clazz = class$13;
                if (clazz == null) {
                    try {
                        clazz = class$13 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Character.TYPE)) {
                Class<?> clazz = class$15;
                if (clazz == null) {
                    try {
                        clazz = class$15 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            throw new IllegalStateException("Should never happen - primitive type is not a primitive?");
        }
        return targetType;
    }
}

