/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.binding.message.StateManageableMessageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;

class DefaultMessageContext
implements StateManageableMessageContext {
    private static final Log logger;
    private MessageSource messageSource;
    private Map sourceMessages = new CachingMapDecorator(new LinkedHashMap()){

        protected Object create(Object source) {
            return new ArrayList();
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.binding.message.DefaultMessageContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public DefaultMessageContext(MessageSource messageSource) {
        this.init(messageSource);
    }

    public Message[] getAllMessages() {
        ArrayList messages = new ArrayList();
        Iterator it = this.sourceMessages.values().iterator();
        while (it.hasNext()) {
            messages.addAll((List)it.next());
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public Message[] getMessagesBySource(Object source) {
        List messages = (List)this.sourceMessages.get(source);
        return messages.toArray(new Message[messages.size()]);
    }

    public Message[] getMessagesByCriteria(MessageCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"The message criteria is required");
        ArrayList<Message> messages = new ArrayList<Message>();
        Iterator it = this.sourceMessages.values().iterator();
        while (it.hasNext()) {
            List sourceMessages = (List)it.next();
            Iterator it2 = sourceMessages.iterator();
            while (it2.hasNext()) {
                Message message = (Message)it2.next();
                if (!criteria.test(message)) continue;
                messages.add(message);
            }
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public boolean hasErrorMessages() {
        Iterator it = this.sourceMessages.values().iterator();
        while (it.hasNext()) {
            List sourceMessages = (List)it.next();
            Iterator it2 = sourceMessages.iterator();
            while (it2.hasNext()) {
                Message message = (Message)it2.next();
                if (message.getSeverity() != Severity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    public void addMessage(MessageResolver messageResolver) {
        Locale currentLocale = LocaleContextHolder.getLocale();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving message using " + messageResolver));
        }
        Message message = messageResolver.resolveMessage(this.messageSource, currentLocale);
        List messages = (List)this.sourceMessages.get(message.getSource());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding resolved message " + message));
        }
        messages.add(message);
    }

    public void clearMessages() {
        this.sourceMessages.clear();
    }

    public Serializable createMessagesMemento() {
        return new HashMap(this.sourceMessages);
    }

    public void restoreMessages(Serializable messagesMemento) {
        this.sourceMessages.putAll((Map)((Object)messagesMemento));
    }

    private void init(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.sourceMessages.get(null);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("sourceMessages", (Object)this.sourceMessages).toString();
    }
}

