/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.excel.impl;

import com.ibatis.sqlmap.client.SqlMapClient;
import egovframework.rte.fdl.cmmn.exception.BaseException;
import egovframework.rte.fdl.excel.EgovExcelMapping;
import egovframework.rte.fdl.excel.EgovExcelService;
import egovframework.rte.fdl.excel.impl.EgovExcelServiceDAO;
import egovframework.rte.fdl.excel.impl.EgovExcelServiceMapper;
import egovframework.rte.fdl.filehandling.EgovFileUtil;
import egovframework.rte.fdl.string.EgovObjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public class EgovExcelServiceImpl
implements EgovExcelService,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovExcelServiceImpl.class);
    private MessageSource messageSource;
    private ApplicationContext applicationContext;
    private String mapClass;
    private String mapBeanName;
    private EgovExcelServiceDAO dao;
    private EgovExcelServiceMapper excelBatchMapper;
    private SqlMapClient sqlMapClient;
    private SqlSessionTemplate sqlSessionTemplate;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) throws Exception {
        this.sqlMapClient = sqlMapClient;
        this.dao = new EgovExcelServiceDAO(this.sqlMapClient);
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) throws Exception {
        this.sqlSessionTemplate = sqlSessionTemplate;
        this.excelBatchMapper = new EgovExcelServiceMapper(this.sqlSessionTemplate);
    }

    public void setMapClass(String mapClass) throws BaseException {
        this.mapClass = mapClass;
        LOGGER.debug("mapClass : {}", (Object)mapClass);
    }

    public void setMapBeanName(String mapBeanName) throws BaseException {
        this.mapBeanName = mapBeanName;
        LOGGER.debug("mapBeanName : {}", (Object)mapBeanName);
    }

    @Override
    public Workbook createWorkbook(Workbook wb, String filepath) throws BaseException, FileNotFoundException, IOException {
        String fullFileName = filepath;
        LOGGER.debug("EgovExcelServiceImpl.createWorkbook : templatePath is {}", (Object)FilenameUtils.getFullPath((String)fullFileName));
        if (!EgovFileUtil.isExistsFile((String)FilenameUtils.getFullPath((String)fullFileName))) {
            LOGGER.debug("make dir {}", (Object)FilenameUtils.getFullPath((String)fullFileName));
            try {
                FileUtils.forceMkdir((File)new File(FilenameUtils.getFullPath((String)fullFileName)));
            }
            catch (IOException e) {
                throw new IOException("Cannot create directory for path: " + FilenameUtils.getFullPath((String)fullFileName));
            }
        }
        FileOutputStream fileOut = new FileOutputStream(fullFileName);
        LOGGER.debug("EgovExcelServiceImpl.createWorkbook : templatePath is {}", (Object)fullFileName);
        try {
            try {
                LOGGER.debug("ExcelServiceImpl loadExcelObject ...");
                wb.write((OutputStream)fileOut);
            }
            catch (Exception e) {
                LOGGER.error(this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"createWorkbook"}, Locale.getDefault()), (Throwable)e);
                LOGGER.debug("ExcelServiceImpl loadExcelObject end...");
                fileOut.close();
            }
        }
        finally {
            LOGGER.debug("ExcelServiceImpl loadExcelObject end...");
            fileOut.close();
        }
        return wb;
    }

    @Override
    public Workbook loadExcelTemplate(String templateName) throws BaseException, FileNotFoundException, IOException {
        FileInputStream fileIn = new FileInputStream(templateName);
        HSSFWorkbook wb = null;
        LOGGER.debug("EgovExcelServiceImpl.loadExcelTemplate : templatePath is {}", (Object)templateName);
        try {
            try {
                LOGGER.debug("ExcelServiceImpl loadExcelTemplate ...");
                POIFSFileSystem fs = new POIFSFileSystem((InputStream)fileIn);
                wb = new HSSFWorkbook(fs);
            }
            catch (Exception e) {
                LOGGER.error(this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"EgovExcelServiceImpl loadExcelTemplate"}, Locale.getDefault()), (Throwable)e);
                LOGGER.debug("ExcelServiceImpl loadExcelTemplate end...");
                fileIn.close();
            }
        }
        finally {
            LOGGER.debug("ExcelServiceImpl loadExcelTemplate end...");
            fileIn.close();
        }
        return wb;
    }

    @Override
    public XSSFWorkbook loadExcelTemplate(String templateName, XSSFWorkbook wb) throws BaseException, FileNotFoundException, IOException {
        FileInputStream fileIn = new FileInputStream(templateName);
        LOGGER.debug("EgovExcelServiceImpl.loadExcelTemplate(XSSF) : templatePath is {}", (Object)templateName);
        try {
            try {
                LOGGER.debug("ExcelServiceImpl loadExcelTemplate(XSSF) ...");
                wb = new XSSFWorkbook((InputStream)fileIn);
            }
            catch (Exception e) {
                LOGGER.error(this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"EgovExcelServiceImpl loadExcelTemplate(XSSF)"}, Locale.getDefault()), (Throwable)e);
                LOGGER.debug("ExcelServiceImpl loadExcelTemplate(XSSF) end...");
                fileIn.close();
            }
        }
        finally {
            LOGGER.debug("ExcelServiceImpl loadExcelTemplate(XSSF) end...");
            fileIn.close();
        }
        return wb;
    }

    @Override
    public Workbook loadWorkbook(String filepath) throws BaseException, FileNotFoundException, IOException {
        FileInputStream fileIn = new FileInputStream(filepath);
        Workbook wb = this.loadWorkbook(fileIn);
        fileIn.close();
        return wb;
    }

    @Override
    public XSSFWorkbook loadWorkbook(String filepath, XSSFWorkbook wb) throws BaseException, FileNotFoundException, IOException {
        FileInputStream fileIn = new FileInputStream(filepath);
        wb = this.loadWorkbook(fileIn, wb);
        fileIn.close();
        return wb;
    }

    @Override
    public Workbook loadWorkbook(InputStream fileIn) throws BaseException {
        HSSFWorkbook wb = null;
        try {
            LOGGER.debug("ExcelServiceImpl loadWorkbook ...");
            POIFSFileSystem fs = new POIFSFileSystem(fileIn);
            wb = new HSSFWorkbook(fs);
        }
        catch (Exception e) {
            LOGGER.error(this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"loadWorkbook"}, Locale.getDefault()), (Throwable)e);
        }
        return wb;
    }

    @Override
    public XSSFWorkbook loadWorkbook(InputStream fileIn, XSSFWorkbook wb) throws BaseException {
        try {
            LOGGER.debug("ExcelServiceImpl loadWorkbook(XSSF) ...");
            wb = new XSSFWorkbook(fileIn);
        }
        catch (Exception e) {
            LOGGER.error(this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"loadWorkbook(XSSF)"}, Locale.getDefault()), (Throwable)e);
        }
        return wb;
    }

    @Override
    public Integer uploadExcel(String queryId, Sheet sheet, int start, long commitCnt) throws BaseException, Exception {
        LOGGER.debug("sheet.getPhysicalNumberOfRows() : {}", (Object)sheet.getPhysicalNumberOfRows());
        Integer rowsAffected = 0;
        try {
            long rowCnt = sheet.getPhysicalNumberOfRows();
            long cnt = commitCnt == 0L ? rowCnt : commitCnt;
            LOGGER.debug("Runtime.getRuntime().totalMemory() : {}", (Object)Runtime.getRuntime().totalMemory());
            LOGGER.debug("Runtime.getRuntime().freeMemory() : {}", (Object)Runtime.getRuntime().freeMemory());
            long startTime = System.currentTimeMillis();
            int idx = start;
            int i = start;
            while ((long)idx < rowCnt) {
                ArrayList<Object> list = new ArrayList<Object>();
                LOGGER.debug("before Runtime.getRuntime().freeMemory() : {}", (Object)Runtime.getRuntime().freeMemory());
                EgovExcelMapping mapping = null;
                if (this.mapBeanName != null) {
                    mapping = (EgovExcelMapping)this.applicationContext.getBean(this.mapBeanName);
                } else if (this.mapClass != null) {
                    mapping = (EgovExcelMapping)EgovObjectUtil.instantiate((String)this.mapClass);
                } else {
                    throw new RuntimeException(this.getMessageSource().getMessage("error.excel.property.error", null, Locale.getDefault()));
                }
                i = idx;
                while ((long)i < rowCnt && (long)i < cnt + (long)idx) {
                    Row row = sheet.getRow(i);
                    list.add(mapping.mappingColumn(row));
                    ++i;
                }
                if (this.sqlSessionTemplate != null) {
                    rowsAffected = rowsAffected + this.excelBatchMapper.batchInsert(queryId, list);
                } else if (this.sqlMapClient != null) {
                    rowsAffected = rowsAffected + this.dao.batchInsert(queryId, list);
                } else {
                    throw new RuntimeException(this.getMessageSource().getMessage("error.excel.persistence.error", null, Locale.getDefault()));
                }
                LOGGER.debug("after Runtime.getRuntime().freeMemory() : {}", (Object)Runtime.getRuntime().freeMemory());
                LOGGER.debug("rowsAffected : {}", (Object)rowsAffected);
                idx = i;
            }
            LOGGER.debug("batchInsert time is {}", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        LOGGER.debug("uploadExcel result count is {}", (Object)rowsAffected);
        return rowsAffected;
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, int start, long commitCnt) throws BaseException, Exception {
        Workbook wb = this.loadWorkbook(fileIn);
        Sheet sheet = wb.getSheetAt(0);
        return this.uploadExcel(queryId, sheet, start, commitCnt);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, int start, long commitCnt, XSSFWorkbook wb) throws BaseException, Exception {
        wb = this.loadWorkbook(fileIn, wb);
        XSSFSheet sheet = wb.getSheetAt(0);
        return this.uploadExcel(queryId, (Sheet)sheet, start, commitCnt);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, 0, 0L);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, XSSFWorkbook type) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, 0, 0L, type);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, short sheetIndex, int start, long commitCnt) throws BaseException, Exception {
        Workbook wb = this.loadWorkbook(fileIn);
        Sheet sheet = wb.getSheetAt((int)sheetIndex);
        return this.uploadExcel(queryId, sheet, start, commitCnt);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, short sheetIndex, int start, long commitCnt, XSSFWorkbook wb) throws BaseException, Exception {
        wb = this.loadWorkbook(fileIn, wb);
        XSSFSheet sheet = wb.getSheetAt((int)sheetIndex);
        return this.uploadExcel(queryId, (Sheet)sheet, start, commitCnt);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, String sheetName, int start, long commitCnt) throws BaseException, Exception {
        Workbook wb = this.loadWorkbook(fileIn);
        Sheet sheet = wb.getSheet(sheetName);
        return this.uploadExcel(queryId, sheet, start, commitCnt);
    }

    @Override
    public Integer uploadExcel(String queryId, InputStream fileIn, String sheetName, int start, long commitCnt, XSSFWorkbook wb) throws BaseException, Exception {
        wb = this.loadWorkbook(fileIn, wb);
        XSSFSheet sheet = wb.getSheet(sheetName);
        return this.uploadExcel(queryId, (Sheet)sheet, start, commitCnt);
    }
}

