/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.config;

import egovframework.rte.fdl.security.config.SecurityConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.security.authentication.encoding.PlaintextPasswordEncoder;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;

public class SecurityConfigInitializer
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfigInitializer.class);
    private ApplicationContext context;
    private SecurityConfig config;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.config = (SecurityConfig)this.context.getBean(SecurityConfig.class);
    }

    @PostConstruct
    public void init() {
        LOGGER.debug("init() started...");
        if (StringUtils.hasText((String)this.config.getAccessDeniedUrl())) {
            LOGGER.debug("Replaced access denied url : {}", (Object)this.config.getAccessDeniedUrl());
            this.registerAccessDeniedUrl(this.config.getAccessDeniedUrl());
        }
        if (StringUtils.hasText((String)this.config.getLoginUrl())) {
            LOGGER.debug("Replaced login url : {}", (Object)this.config.getLoginUrl());
            this.registerLoginUrl();
        }
        if (StringUtils.hasText((String)this.config.getLoginFailureUrl())) {
            LOGGER.debug("Replaced login failure url : {}", (Object)this.config.getLoginFailureUrl());
            this.registerLoginFailureUrl(this.config.getLoginFailureUrl());
        }
        if (StringUtils.hasText((String)this.config.getLogoutSuccessUrl())) {
            LOGGER.debug("Replaced logout success url : {}", (Object)this.config.getLogoutSuccessUrl());
            this.registerLogoutSuccessUrl(this.config.getLogoutSuccessUrl());
        }
        this.registerJdbcInfo(this.config.getJdbcUsersByUsernameQuery(), this.config.getJdbcAuthoritiesByUsernameQuery(), this.config.getJdbcMapClass());
        if (StringUtils.hasText((String)this.config.getHash())) {
            LOGGER.debug("Password Encoder Algorithm : {}", (Object)this.config.getHash());
            this.registerHash(this.config.getHash(), this.config.isHashBase64());
        }
        if (this.config.getConcurrentMaxSessons() > 0 || StringUtils.hasText((String)this.config.getConcurrentExpiredUrl())) {
            LOGGER.debug("Concurrent max sessions : {}", (Object)this.config.getConcurrentMaxSessons());
            LOGGER.debug("Concurrent concurrent expired url  : {}", (Object)this.config.getConcurrentExpiredUrl());
            this.registerConcurrentControl(this.config.getConcurrentMaxSessons(), this.config.getConcurrentExpiredUrl());
        }
        if (StringUtils.hasText((String)this.config.getDefaultTargetUrl())) {
            LOGGER.debug("Default target url : {}", (Object)this.config.getDefaultTargetUrl());
            this.registerDefaultTargetUrl(this.config.getDefaultTargetUrl());
        }
        LOGGER.debug("init() ended...");
    }

    private <T extends Filter> T getSecurityFilter(Class<T> type) {
        Map filterChainMap = this.context.getBeansOfType(DefaultSecurityFilterChain.class);
        for (DefaultSecurityFilterChain filterChain : filterChainMap.values()) {
            for (Filter filter : filterChain.getFilters()) {
                if (!type.isInstance(filter)) continue;
                return (T)((Filter)type.cast(filter));
            }
        }
        throw new NoSuchBeanDefinitionException(type);
    }

    private void registerLogoutSuccessUrl(String logoutSuccessUrl) {
        LogoutFilter filter = this.getSecurityFilter(LogoutFilter.class);
        this.checkUrl(logoutSuccessUrl);
        try {
            Field field = filter.getClass().getDeclaredField("logoutSuccessHandler");
            field.setAccessible(true);
            SimpleUrlLogoutSuccessHandler logoutSuccessHandler = (SimpleUrlLogoutSuccessHandler)field.get(filter);
            logoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void registerLoginFailureUrl(String loginFailureUrl) {
        UsernamePasswordAuthenticationFilter filter = this.getSecurityFilter(UsernamePasswordAuthenticationFilter.class);
        this.checkUrl(loginFailureUrl);
        SimpleUrlAuthenticationFailureHandler failureHandler = null;
        Method method = null;
        try {
            method = AbstractAuthenticationProcessingFilter.class.getDeclaredMethod("getFailureHandler", null);
            method.setAccessible(true);
            failureHandler = (SimpleUrlAuthenticationFailureHandler)method.invoke((Object)filter, null);
        }
        catch (Exception ex) {
            LOGGER.error("## registerLoginFailureUrl : {}", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        failureHandler.setDefaultFailureUrl(loginFailureUrl);
    }

    private void registerLoginUrl() {
    }

    protected void registerAccessDeniedUrl(String accessDeniedUrl) {
        ExceptionTranslationFilter filter = this.getSecurityFilter(ExceptionTranslationFilter.class);
        this.checkUrl(accessDeniedUrl);
        AccessDeniedHandlerImpl accessDeniedHandler = new AccessDeniedHandlerImpl();
        accessDeniedHandler.setErrorPage(accessDeniedUrl);
        filter.setAccessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
    }

    protected void registerJdbcInfo(String jdbcUsersByUsernameQuery, String jdbcAuthoritiesByUsernameQuery, String jdbcMapClass) {
    }

    protected void registerHash(String hash, boolean isHashBase64) {
        DaoAuthenticationProvider authentication = (DaoAuthenticationProvider)this.context.getBean(DaoAuthenticationProvider.class);
        if (hash.equalsIgnoreCase("plaintext")) {
            authentication.setPasswordEncoder((Object)new PlaintextPasswordEncoder());
        } else if (hash.equalsIgnoreCase("md5")) {
            Md5PasswordEncoder password = new Md5PasswordEncoder();
            password.setEncodeHashAsBase64(isHashBase64);
            authentication.setPasswordEncoder((Object)password);
        } else if (hash.equalsIgnoreCase("sha")) {
            ShaPasswordEncoder password = new ShaPasswordEncoder();
            password.setEncodeHashAsBase64(isHashBase64);
            authentication.setPasswordEncoder((Object)password);
        } else if (hash.equalsIgnoreCase("sha-256")) {
            ShaPasswordEncoder password = new ShaPasswordEncoder(256);
            password.setEncodeHashAsBase64(isHashBase64);
            authentication.setPasswordEncoder((Object)password);
        } else if (hash.equalsIgnoreCase("bcrypt")) {
            BCryptPasswordEncoder password = new BCryptPasswordEncoder();
            authentication.setPasswordEncoder((Object)password);
        } else {
            throw new IllegalArgumentException("'hash' attribute have to be plaintext, md5, sha, sha-256, or bcrypt");
        }
    }

    private void registerConcurrentControl(int concurrentMaxSessons, String concurrentExpiredUrl) {
    }

    private void registerDefaultTargetUrl(String defaultTargetUrl) {
        AbstractAuthenticationProcessingFilter filter = this.getSecurityFilter(AbstractAuthenticationProcessingFilter.class);
        this.checkUrl(defaultTargetUrl);
        Method method = null;
        try {
            method = AbstractAuthenticationProcessingFilter.class.getDeclaredMethod("getSuccessHandler", null);
            method.setAccessible(true);
            SavedRequestAwareAuthenticationSuccessHandler successHandler = (SavedRequestAwareAuthenticationSuccessHandler)method.invoke((Object)filter, null);
            successHandler.setAlwaysUseDefaultTargetUrl(true);
            successHandler.setDefaultTargetUrl(defaultTargetUrl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void checkUrl(String url) {
        if (!UrlUtils.isValidRedirectUrl((String)url)) {
            LOGGER.warn("Url ({} is not a valid redirect URL (must start with '/' or http(s))", (Object)url);
        }
    }
}

