/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.userdetails.jdbc;

import egovframework.rte.fdl.security.userdetails.EgovUserDetails;
import egovframework.rte.fdl.security.userdetails.jdbc.EgovUsersByUsernameMapping;
import egovframework.rte.fdl.string.EgovObjectUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.JdbcUserDetailsManager;

public class EgovJdbcUserDetailsManager
extends JdbcUserDetailsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovJdbcUserDetailsManager.class);
    private EgovUserDetails userDetails = null;
    private EgovUsersByUsernameMapping usersByUsernameMapping;
    private String mapClass;
    private RoleHierarchy roleHierarchy = null;

    public void setMapClass(String mapClass) {
        this.mapClass = mapClass;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }

    protected void initDao() throws ApplicationContextException {
        super.initDao();
        try {
            this.initMappingSqlQueries();
        }
        catch (Exception e) {
            LOGGER.error("EgovJdbcUserDetailsManager.initDao.Exception : {}", (Object)e.toString(), (Object)e);
        }
    }

    private void initMappingSqlQueries() throws Exception {
        LOGGER.debug("## EgovJdbcUserDetailsManager query : {}", (Object)this.getUsersByUsernameQuery());
        LOGGER.debug("Mapping Class : {}", (Object)this.mapClass);
        Class clazz = EgovObjectUtil.loadClass((String)this.mapClass);
        Constructor constructor = clazz.getConstructor(DataSource.class, String.class);
        Object[] params = new Object[]{this.getDataSource(), this.getUsersByUsernameQuery()};
        this.usersByUsernameMapping = (EgovUsersByUsernameMapping)((Object)constructor.newInstance(params));
    }

    protected List<UserDetails> loadUsersByUsername(String username) {
        List list = this.usersByUsernameMapping.execute(username);
        ArrayList<UserDetails> newList = new ArrayList<UserDetails>();
        for (EgovUserDetails user : list) {
            newList.add((UserDetails)user);
        }
        return newList;
    }

    public EgovUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        List<UserDetails> users = this.loadUsersByUsername(username);
        if (users.size() == 0) {
            LOGGER.debug("Query returned no results for user '{}'", (Object)username);
            throw new UsernameNotFoundException(this.messages.getMessage("EgovJdbcUserDetailsManager.notFound", new Object[]{username}, "Username {0} not found"));
        }
        UserDetails obj = users.get(0);
        this.userDetails = (EgovUserDetails)obj;
        HashSet dbAuthsSet = new HashSet();
        dbAuthsSet.addAll(this.loadUserAuthorities(this.userDetails.getUsername()));
        ArrayList dbAuths = new ArrayList(dbAuthsSet);
        this.addCustomAuthorities(this.userDetails.getUsername(), dbAuths);
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException(this.messages.getMessage("EgovJdbcUserDetailsManager.noAuthority", new Object[]{username}, "User {0} has no GrantedAuthority"));
        }
        Collection authorities = this.roleHierarchy.getReachableGrantedAuthorities(dbAuths);
        return new EgovUserDetails(this.userDetails.getUsername(), this.userDetails.getPassword(), this.userDetails.isEnabled(), true, true, true, authorities, this.userDetails.getEgovUserVO());
    }

    public EgovUserDetails getAuthenticatedUser() throws UsernameNotFoundException, DataAccessException {
        return this.loadUserByUsername(SecurityContextHolder.getContext().getAuthentication().getName());
    }
}

