/*
 * Copyright 2008-2009 MOPAS(Ministry of Public Administration and Security).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package egovframework.rte.ptl.mvc.validation;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.springframework.validation.Errors;
import org.springmodules.validation.commons.FieldChecks;
/**
 * RteFieldChecks.java
 * <p><b>NOTE:</b> <pre> 주민등록번호, 한글체크 같은 Jakarta Commons Validator에서 제공되지 않는 validation rule을 추가로 제공한다.
 * 실제 validation check는 RteGenericValidator에 위임한다.</pre>
 *
 * @author 실행환경 개발팀 함철
 * @since 2009.06.01
 * @version 1.0
 * @see
 *
 * <pre>
 * << 개정이력(Modification Information) >>
 *   
 *   수정일            수정자           수정내용
 *  -------    --------    ---------------------------
 *   2009.05.30  함철            최초 생성
 *   2011.09.23 이기하           validateEnglish 메소드 추가
 *   
 * </pre>
 */
public class RteFieldChecks extends FieldChecks{
	/**
	 * 주민등록번호 유효성 체크
	 * @param bean
	 * @param va
	 * @param field
	 * @param errors
	 * @return
	 */
	public static boolean validateIhIdNum(Object bean, ValidatorAction va,
            Field field, Errors errors){
		
		String ihidnum = FieldChecks.extractValue(bean, field); 
		
		if(!RteGenericValidator.isValidIdIhNum(ihidnum)){
			FieldChecks.rejectValue(errors, field, va);
			return false;
		}else{
			return true;
		}
	}
	
	/**
	 * 한글여부 체크
	 * @param bean
	 * @param va
	 * @param field
	 * @param errors
	 * @return
	 */
	public static boolean validateKorean(Object bean, ValidatorAction va,
            Field field, Errors errors){
		
		String value = FieldChecks.extractValue(bean, field);
		
		if(!RteGenericValidator.isKorean(value)){
			FieldChecks.rejectValue(errors, field, va);
			return false;
		}else{
			return true;
		}		
	}
	
	/**
	 * 영어여부 체크
	 * @param bean
	 * @param va
	 * @param field
	 * @param errors
	 * @return
	 */
	public static boolean validateEnglish(Object bean, ValidatorAction va,
			Field field, Errors errors){

		String value = FieldChecks.extractValue(bean, field);

		if(!RteGenericValidator.isEnglish(value)){
			FieldChecks.rejectValue(errors, field, va);
			return false;
		}else{
			return true;
		}
	}
	
	public static boolean validateHtmlTag(Object bean, ValidatorAction va,
            Field field, Errors errors){
		
		String value = FieldChecks.extractValue(bean, field);
		
		if(!RteGenericValidator.isHtmlTag(value)){
			FieldChecks.rejectValue(errors, field, va);
			return false;
		}else{
			return true;
		}
	}
}
