/*==============================================================*/
/* MBean Table 테이블 :19                      								  */
/*==============================================================*/

/* 1. GC 테이블 */

ALTER TABLE OE2TNGCINFO DROP CONSTRAINT OE2TNGCINFO_PK;

DROP TABLE OE2TNGCINFO;

DROP SEQUENCE SQ_OE2TNGCINFO_GC_SN;

CREATE SEQUENCE SQ_OE2TNGCINFO_GC_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;

CREATE TABLE OE2TNGCINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		MNR_GC_CO NUMBER(10 , 0),
		MNR_GC_TM NUMBER(15 , 0),
		MJR_GC_CO NUMBER(15 , 0),
		MJR_GC_TM NUMBER(10 , 0)
	);
	
ALTER TABLE OE2TNGCINFO ADD CONSTRAINT OE2TNGCINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNGCINFO_FK ON OE2TNGCINFO (SN,CNTNR_SN,CUR_TIME);

/* 2. JBoss JDBC테이블 */

ALTER TABLE OE2TNJBSSJDBCINFO DROP CONSTRAINT OE2TNJBSSJDBCINFO_PK;

DROP TABLE OE2TNJBSSJDBCINFO;

DROP SEQUENCE SQ_OE2TNJBSSJDBCINFO_SN;

CREATE SEQUENCE SQ_OE2TNJBSSJDBCINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;

CREATE TABLE OE2TNJBSSJDBCINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		JDBC_NM VARCHAR2(50),
		IDL_CO NUMBER(5 , 0),
		ALLC_CO NUMBER(5 , 0),
		CUR_CO NUMBER(5 , 0),
		MXMM_CNNC_USE_CO NUMBER(5 , 0),
		CNNC_CREAT_CO NUMBER(5 , 0),
		CNNC_DESTRC_CO NUMBER(5 , 0),
		AVBL_CNNC_CO NUMBER(5 , 0)
	);

ALTER TABLE OE2TNJBSSJDBCINFO ADD CONSTRAINT OE2TNJBSSJDBCINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNJBSSJDBCINFO_FK ON OE2TNJBSSJDBCINFO (SN,CNTNR_SN,CUR_TIME);

/* 3. JBoss Session 테이블 */ 

ALTER TABLE OE2TNJBSSSESIONINFO DROP CONSTRAINT OE2TNJBSSSESIONINFO_PK;

DROP TABLE OE2TNJBSSSESIONINFO;

DROP SEQUENCE SQ_OE2TNJBSSSESIONINFO_SN;

CREATE SEQUENCE SQ_OE2TNJBSSSESIONINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNJBSSSESIONINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		ACTIVE_SESION NUMBER(5 , 0),
		SESION_CO NUMBER(5 , 0),
		MXMM_ACTIVE NUMBER(5 , 0),
		SESION_MXMM_BEING_TIME NUMBER(10 , 0),
		SESION_AVRG_BEING_TIME NUMBER(10 , 0),
		REJECT_SESION NUMBER(5 , 0),
		EXPRTN_SESION NUMBER(5 , 0),
		WAIT_QUEUE_CO NUMBER(5 , 0)
	);

ALTER TABLE OE2TNJBSSSESIONINFO ADD CONSTRAINT OE2TNJBSSSESIONINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNJBSSSESIONINFO_FK ON OE2TNJBSSSESIONINFO (SN,CNTNR_SN,CUR_TIME);

/* 4. JBoss Thread 테이블	   */

ALTER TABLE OE2TNJBSSTHREADINFO DROP CONSTRAINT OE2TNJBSSTHREADINFO_PK;

DROP TABLE OE2TNJBSSTHREADINFO;

DROP SEQUENCE SQ_OE2TNJBSSTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNJBSSTHREADINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;

CREATE TABLE OE2TNJBSSTHREADINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_THREAD_CO NUMBER(5 , 0),
		ALIVE_CO NUMBER(5 , 0),
		MXMM_THREAD_CO NUMBER(5 , 0),
		CUR_THREAD_BUSY_CO NUMBER(5 , 0)
	);

ALTER TABLE OE2TNJBSSTHREADINFO ADD CONSTRAINT OE2TNJBSSTHREADINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNJBSSTHREADINFO_FK ON OE2TNJBSSTHREADINFO (SN,CNTNR_SN,CUR_TIME);
/* 5. JEUS JDBC 테이블	   */	  

ALTER TABLE OE2TNJEUSJDBCINFO DROP CONSTRAINT OE2TNJEUSJDBCINFO_PK;

DROP TABLE OE2TNJEUSJDBCINFO;

DROP SEQUENCE SQ_OE2TNJEUSJDBCINFO_SN;

CREATE SEQUENCE SQ_OE2TNJEUSJDBCINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNJEUSJDBCINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		JDBC_NM VARCHAR2(50),
		IDL_CO NUMBER(5 , 0),
		CUR_CO NUMBER(5 , 0),
		TOT_CO NUMBER(5 , 0)
	);

ALTER TABLE OE2TNJEUSJDBCINFO ADD CONSTRAINT OE2TNJEUSJDBCINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNJEUSJDBCINFO_FK ON OE2TNJEUSJDBCINFO (SN,CNTNR_SN,CUR_TIME);

/* 6. JEUS Session 테이블	   */	  

ALTER TABLE OE2TNJEUSSESIONINFO DROP CONSTRAINT OE2TNJEUSSESIONINFO_PK;

DROP TABLE OE2TNJEUSSESIONINFO;

DROP SEQUENCE SQ_OE2TNJEUSSESIONINFO_SN;

CREATE SEQUENCE SQ_OE2TNJEUSSESIONINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNJEUSSESIONINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_THREAD_CO NUMBER(5 , 0),
		MXMM_THREAD_CO NUMBER(5 , 0),
		WAIT_QUEUE_CO NUMBER(5 , 0)
	);
	
ALTER TABLE OE2TNJEUSSESIONINFO ADD CONSTRAINT OE2TNJEUSSESIONINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNJEUSSESIONINFO_FK ON OE2TNJEUSSESIONINFO (SN,CNTNR_SN,CUR_TIME);
/* 7. JEUS Thread 테이블	   */		  	  

ALTER TABLE OE2TNJEUSTHREADINFO DROP CONSTRAINT OE2TNJEUSTHREADINFO_PK;

DROP TABLE OE2TNJEUSTHREADINFO;

DROP SEQUENCE SQ_OE2TNJEUSTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNJEUSTHREADINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNJEUSTHREADINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		THREAD_SIZE NUMBER(5 , 0),
		THREAD_CORE_SIZE NUMBER(5 , 0),
		THREAD_MXMM_SIZE NUMBER(5 , 0),
		THREAD_EXC_TIME_CO NUMBER(5 , 0),
		THREAD_EXC_MUMM_TIME NUMBER(5 , 0),
		THREAD_EXC_MXMM_TIME NUMBER(5 , 0),
		QUEUE_TIME NUMBER(10 , 0),
		QUEUE_MUMM_TIME NUMBER(10 , 0),
		QUEUE_MXMM_TIME NUMBER(10 , 0),
		QUEUE_CUR_SIZE NUMBER(5 , 0),
		QUEUE_MUMM_SIZE NUMBER(5 , 0),
		QUEUE_MXMM_SIZE NUMBER(5 , 0)
	);
	
ALTER TABLE OE2TNJEUSTHREADINFO ADD CONSTRAINT OE2TNJEUSTHREADINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNJEUSTHREADINFO_FK ON OE2TNJEUSTHREADINFO (SN,CNTNR_SN,CUR_TIME);

/* 8. LOADED CLASS 테이블	  */

ALTER TABLE OE2TNLOADCLASSINFO DROP CONSTRAINT OE2TNLOADCLASSINFO_PK;

DROP TABLE OE2TNLOADCLASSINFO;

DROP SEQUENCE SQ_OE2TNLOADCLASSINFO_CLASS_SN;

CREATE SEQUENCE SQ_OE2TNLOADCLASSINFO_CLASS_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;

CREATE TABLE OE2TNLOADCLASSINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		LOAD_CLASS_CO NUMBER(10 , 0),
		TOT_CLASS_CO NUMBER(10 , 0),
		UNLDNG_CLASS_CO NUMBER(10 , 0)
	);
	
ALTER TABLE OE2TNLOADCLASSINFO ADD CONSTRAINT OE2TNLOADCLASSINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNLOADCLASSINFO_FK ON OE2TNLOADCLASSINFO (SN,CNTNR_SN,CUR_TIME);

/* 9. 모델 클래스 정보 */


ALTER TABLE OE2TNMODELCLASSINFO DROP CONSTRAINT OE2TNMODELCLASSINFO_PK;

DROP TABLE OE2TNMODELCLASSINFO;

DROP SEQUENCE SQ_OE2TNMODELCLASSINFO_SN;

CREATE SEQUENCE SQ_OE2TNMODELCLASSINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNMODELCLASSINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CLASS_COLCT CLOB,
		INTRFC_COLCT CLOB
	);
	
ALTER TABLE OE2TNMODELCLASSINFO ADD CONSTRAINT OE2TNMODELCLASSINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNMODELCLASSINFO_FK ON OE2TNMODELCLASSINFO (SN,CNTNR_SN,CUR_TIME);

/* 10. MEMORY 테이블	*/	  

ALTER TABLE OE2TNMORYINFO DROP CONSTRAINT OE2TNMORYINFO_PK;

DROP TABLE OE2TNMORYINFO;

DROP SEQUENCE SQ_OE2TNMORYINFO_MORY_SN;

CREATE SEQUENCE SQ_OE2TNMORYINFO_MORY_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 0
  CYCLE
  CACHE 20
  ORDER;
  
CREATE TABLE OE2TNMORYINFO (
		SN NUMBER(10 , 0) NOT NULL,
		HPMORY_USAGE NUMBER(20 , 0),
		NNHPMORY_USAGE NUMBER(20 , 0),
		CODECACHE_PEAK_USAGE NUMBER(20 , 0),
		CODECACHE_USAGE NUMBER(20 , 0),
		EDENSPACE_PEAK_USAGE NUMBER(20 , 0),
		EDENSPACE_USAGE NUMBER(20 , 0),
		PERMGEN_PEAK_USAGE NUMBER(20 , 0),
		PERMGEN_USAGE NUMBER(20 , 0),
		SURVIVORSPACE_PEAK_USAGE NUMBER(20 , 0),
		SURVIVORSPACE_USAGE NUMBER(20 , 0),
		TENUREDGEN_PEAK_USAGE NUMBER(20 , 0),
		TENUREDGEN_USAGE NUMBER(20 , 0),
		PERMGENRO_PEAK_USAGE NUMBER(20 , 0),
		PERMGENRO_USAGE NUMBER(20 , 0),
		PERMGENRW_PEAK_USAGE NUMBER(20 , 0),
		PERMGENRW_USAGE NUMBER(20 , 0),
		APP_NAME VARCHAR2(20),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		HPMORY_CONFM_USAGE NUMBER(20 , 0),
		HPMORY_MXMM_USAGE NUMBER(20 , 0),
		NNHPMORY_CONFM_USAGE NUMBER(20 , 0),
		NNHPMORY_MXMM_USAGE NUMBER(20 , 0),
		CODECACHE_CONFM_USAGE NUMBER(20 , 0),
		CODECACHE_MXMM_USAGE NUMBER(20 , 0),
		EDENSPACE_CONFM_USAGE NUMBER(20 , 0),
		EDENSPACE_MXMM_USAGE NUMBER(20 , 0),
		PERMGEN_CONFM_USAGE NUMBER(20 , 0),
		PERMGEN_MXMM_USAGE NUMBER(20 , 0),
		PERMGENRO_CONFM_USAGE NUMBER(20 , 0),
		PERMGENRO_MXMM_USAGE NUMBER(20 , 0),
		PERMGENRW_CONFM_USAGE NUMBER(20 , 0),
		PERMGENRW_MXMM_USAGE NUMBER(20 , 0),
		SURVIVORSPACE_CONFM_USAGE NUMBER(20 , 0),
		SURVIVORSPACE_MXMM_USAGE NUMBER(20 , 0),
		TENUREDGEN_CONFM_USAGE NUMBER(20 , 0),
		TENUREDGEN_MXMM_USAGE NUMBER(20 , 0),
		WAS_KND CHAR(2)
	);
	
ALTER TABLE OE2TNMORYINFO ADD CONSTRAINT OE2TNMORYINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNMORYINFO_FK ON OE2TNMORYINFO (SN,CNTNR_SN,CUR_TIME,WAS_KND);

/* 11. OS 및 CPU 테이블 */

ALTER TABLE OE2TNOSCPUINFO DROP CONSTRAINT OE2TNOSCPUINFO_PK;

DROP TABLE OE2TNOSCPUINFO;

DROP SEQUENCE SQ_OE2TNOSCPUINFO_SN;

CREATE SEQUENCE SQ_OE2TNOSCPUINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;

CREATE TABLE OE2TNOSCPUINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		ORMPM NUMBER(10 , 0),
		CPU_USGQTY NUMBER(7 , 2)
	);

ALTER TABLE OE2TNOSCPUINFO ADD CONSTRAINT OE2TNOSCPUINFO_PK PRIMARY KEY (SN);	  

CREATE UNIQUE INDEX OE2TNOSCPUINFO_FK ON OE2TNOSCPUINFO (SN,CNTNR_SN,CUR_TIME);
/* 12. OS 및 런타임 테이블 */

ALTER TABLE OE2TNOSRUNTIMEINFO DROP CONSTRAINT OE2TNOSRUNTIMEINFO_PK;

DROP TABLE OE2TNOSRUNTIMEINFO;

DROP SEQUENCE SQ_OE2TNOSRUNTIMEINFO_SN;

CREATE SEQUENCE SQ_OE2TNOSRUNTIMEINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNOSRUNTIMEINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		ARCHTC VARCHAR2(10),
		AVBL_PRCSR NUMBER(3 , 0),
		OPERSYSM_NM VARCHAR2(50),
		OPERSYSM_VER VARCHAR2(40),
		JVM_NM VARCHAR2(50),
		JVM_VENDOR VARCHAR2(50),
		JIT_NM VARCHAR2(50),
		JVM_VER VARCHAR2(100)
	);

ALTER TABLE OE2TNOSRUNTIMEINFO ADD CONSTRAINT OE2TNOSRUNTIMEINFO_PK PRIMARY KEY (CNTNR_SN);

/* 13. SCHEDULE 테이블 */

ALTER TABLE OE2TNSCHDULINFO DROP CONSTRAINT OE2TNSCHDULINFO_PK;

DROP TABLE OE2TNSCHDULINFO;

DROP SEQUENCE SQ_OE2TNSCHDULINFO_SN;

CREATE SEQUENCE SQ_OE2TNSCHDULINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNSCHDULINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		SCHDUL_NM VARCHAR2(50),
		GROUP_NM VARCHAR2(60),
		JOB_NM VARCHAR2(50),
		CLASS_NM VARCHAR2(255),
		SCHDUL_CYCLE VARCHAR2(20),
		APLCTN_NM VARCHAR2(20),
		OPERT_CN CLOB,
		TIME_OF_FST_EXEC NUMBER(5 , 0),
		TIME_OF_LST_EXEC NUMBER(5 , 0),
		CUR_TIME TIMESTAMP(6),
		TRIGR_KND VARCHAR2(20)
	);
	
ALTER TABLE OE2TNSCHDULINFO ADD CONSTRAINT OE2TNSCHDULINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNSCHDULINFO_FK ON OE2TNSCHDULINFO (SN,CNTNR_SN,CUR_TIME);

/* 14. TOMCAT SESSION 테이블 */

ALTER TABLE OE2TNTMCTSESIONINFO DROP CONSTRAINT OE2TNTMCTSESIONINFO_PK;

DROP TABLE OE2TNTMCTSESIONINFO;

DROP SEQUENCE SQ_OE2TNTMCTSESIONINFO_SN;

CREATE SEQUENCE SQ_OE2TNTMCTSESIONINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNTMCTSESIONINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		ACTIVE_SESION NUMBER(5 , 0),
		SESION_CO NUMBER(5 , 0),
		MXMM_ACTIVE NUMBER(5 , 0),
		SESION_MXMM_BEING_TIME NUMBER(10 , 0),
		SESION_AVRG_BEING_TIME NUMBER(10 , 0),
		REJECT_SESION NUMBER(5 , 0),
		EXPRTN_SESION NUMBER(5 , 0),
		WAIT_QUEUE_CO NUMBER(5 , 0)
	);
	
ALTER TABLE OE2TNTMCTSESIONINFO ADD CONSTRAINT OE2TNTMCTSESIONINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNTMCTSESIONINFO_FK ON OE2TNTMCTSESIONINFO (SN,CNTNR_SN,CUR_TIME);
	  
/* 15. TOMCAT THREAD 테이블 */

ALTER TABLE OE2TNTMCTTHREADINFO DROP CONSTRAINT OE2TNTMCTTHREADINFO_PK;

DROP TABLE OE2TNTMCTTHREADINFO;

DROP SEQUENCE SQ_OE2TNTMCTTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNTMCTTHREADINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNTMCTTHREADINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		CUR_THREAD_CO NUMBER(5 , 0),
		ALIVE_CO NUMBER(5 , 0),
		MXMM_THREAD_CO NUMBER(5 , 0),
		CUR_THREAD_BUSY_CO NUMBER(5 , 0)
	);
	
ALTER TABLE OE2TNTMCTTHREADINFO ADD CONSTRAINT OE2TNTMCTTHREADINFO_PK PRIMARY KEY (SN);

/* 16.WEBLOGIC JDBC 테이블 */

ALTER TABLE OE2TNWBLGJDBCINFO DROP CONSTRAINT OE2TNWBLGJDBCINFO_PK;

DROP TABLE OE2TNWBLGJDBCINFO;

DROP SEQUENCE SQ_OE2TNWBLGJDBCINFO_SN;

CREATE SEQUENCE SQ_OE2TNWBLGJDBCINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNWBLGJDBCINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		JDBC_NM VARCHAR2(50),
		CNNC_AVRG_CO NUMBER(5 , 0),
		CNNC_CUR_CO NUMBER(5 , 0),
		CNNC_HGH_CO NUMBER(5 , 0),
		CNNC_DELAY_TM NUMBER(5 , 0),
		CNNC_TOT_CO NUMBER(5 , 0),
		CUR_CPCTY NUMBER(5 , 0),
		CUR_CPCTY_HGH_CO NUMBER(5 , 0),
		LKGE_CNNC_CO NUMBER(5 , 0),
		NO_AVBL NUMBER(5 , 0),
		NO_UNAVBL NUMBER(22 , 0),
		STATMNT VARCHAR2(30),
		WAIT_CNNC_CUR_CO NUMBER(5 , 0),
		WAIT_CNNC_FAILR_TOT NUMBER(5 , 0),
		WAIT_CNNC_HGH_CO NUMBER(5 , 0),
		WAIT_CNNC_TOT NUMBER(5 , 0),
		WAIT_SECND_HGH_CO NUMBER(5 , 0)
	);
	
ALTER TABLE OE2TNWBLGJDBCINFO ADD CONSTRAINT OE2TNWBLGJDBCINFO_PK PRIMARY KEY (SN);

CREATE UNIQUE INDEX OE2TNWBLGJDBCINFO_FK ON OE2TNWBLGJDBCINFO (SN,CNTNR_SN,CUR_TIME);

/* 17. WEBLOGIC THREAD 테이블 */

ALTER TABLE OE2TNWBLGTHREADINFO DROP CONSTRAINT OE2TNWBLGTHREADINFO_PK;

DROP TABLE OE2TNWBLGTHREADINFO;

DROP SEQUENCE SQ_OE2TNWBLGTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNWBLGTHREADINFO_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1
  CYCLE
  CACHE 20
  NOORDER;
  
CREATE TABLE OE2TNWBLGTHREADINFO (
		SN NUMBER(10 , 0) NOT NULL,
		CUR_TIME TIMESTAMP(6),
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		COMPET_RQEST_CO NUMBER(10 , 0),
		THREAD_IDL_CO NUMBER(10 , 0),
		THREAD_CO NUMBER(10 , 0),
		THREAD_TOT_CO NUMBER(10 , 0),
		HEALTH_STTUS VARCHAR2(50),
		HGH_POSSESN_THREAD_CO NUMBER(5 , 0),
		QUEUE_LT NUMBER(5 , 0),
		QUEUE_MXMM_LT NUMBER(5 , 0),
		STABLE_THREAD_CO NUMBER(5 , 0),
		THROUGHPUT FLOAT(5)
	);
	
ALTER TABLE OE2TNWBLGTHREADINFO ADD CONSTRAINT OE2TNWBLGTHREADINFO_PK PRIMARY KEY (SN);

/* 18. JDBC JOB 테이블 */

ALTER TABLE OE2TNJDBCJOBMAPNGINFO DROP CONSTRAINT OE2TNJDBCJOBMAPNGINFO_PK;

DROP TABLE OE2TNJDBCJOBMAPNGINFO;

CREATE TABLE OE2TNJDBCJOBMAPNGINFO (
		WAS_KND VARCHAR2(2) NOT NULL,
		JDBC_NM VARCHAR2(50) NOT NULL,
		JDBC_JOB_NM VARCHAR2(150),
		DB_AT CHAR(1)
	);
	
ALTER TABLE OE2TNJDBCJOBMAPNGINFO ADD CONSTRAINT OE2TNJDBCJOBMAPNGINFO_PK PRIMARY KEY (WAS_KND, JDBC_NM);		  
	 
/* 19.스케줄 엄무명 정보 테이블 */

ALTER TABLE OE2TNSCHDULJOBINFO DROP CONSTRAINT OE2TNSCHDULJOBINFO_PK;

DROP TABLE OE2TNSCHDULJOBINFO;

CREATE TABLE OE2TNSCHDULJOBINFO (
		JOB_ENG_NM VARCHAR2(1024) NOT NULL,
		JOB_KOREAN_NM VARCHAR2(1024)
	);
	
ALTER TABLE OE2TNSCHDULJOBINFO ADD CONSTRAINT OE2TNSCHDULJOBINFO_PK PRIMARY KEY (JOB_ENG_NM);	

	  
/*==============================================================*/
/* Admin Table 테이블 : 11			                                */
/*==============================================================*/

/* MBean Client 설정 테이블 삭제 */
ALTER TABLE OE2TNMBCLIENT DROP CONSTRAINT OE2TNMBCLIENT_FK1;

ALTER TABLE OE2TNMBCLIENT DROP CONSTRAINT OE2TNMBCLIENT_PK;

DROP INDEX OE2TNMBCLIENT_FK1;

DROP TABLE OE2TNMBCLIENT;

/* 어플리케이션 정보 테이블 삭제 */
ALTER TABLE OE2TNAPLCTNINFO DROP CONSTRAINT OE2TNAPLCTNINFO_FK1;

ALTER TABLE OE2TNAPLCTNINFO DROP CONSTRAINT OE2TNAPLCTNINFO_PK;

DROP INDEX OE2TNAPLCTNINFO_FK1;

DROP TABLE OE2TNAPLCTNINFO;

/* 컨테이너정보 테이블 삭제*/

ALTER TABLE OE2TNCNTNRINFO DROP CONSTRAINT OE2TNCNTNRINFO_FK1;

ALTER TABLE OE2TNCNTNRINFO DROP CONSTRAINT OE2TNCNTNRINFO_PK;

DROP INDEX OE2TNCNTNRINFO_FK1;

DROP TABLE OE2TNCNTNRINFO;




/* 1.모니터링 서버 테이블 */

ALTER TABLE OE2TNMNTRGSERVERINFO DROP CONSTRAINT OE2TNMNTRGSERVERINFO_PK;

DROP TABLE OE2TNMNTRGSERVERINFO;

CREATE TABLE OE2TNMNTRGSERVERINFO (
		SERVER_ID CHAR(20) NOT NULL,
		SERVER_NM VARCHAR2(60),
		SERVER_KND CHAR(2),
		WAS_VER VARCHAR2(20),
		SERVER_MNGR_ID VARCHAR2(20),
		SERVER_MNGR_PASSWORD VARCHAR2(20),
		SERVER_IP VARCHAR2(23),
		HST_NM VARCHAR2(20),
		OPERSYSM_INFO VARCHAR2(2000),
		CPU_INFO VARCHAR2(2000),
		MORY_INFO VARCHAR2(2000),
		DISK_INFO VARCHAR2(2000),
		USE_AT CHAR(1)
	);
	
ALTER TABLE OE2TNMNTRGSERVERINFO ADD CONSTRAINT OE2TNMNTRGSERVERINFO_PK PRIMARY KEY (SERVER_ID);

/* 2.컨테이너정보 테이블 생성*/

CREATE TABLE OE2TNCNTNRINFO (
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		SERVER_ID CHAR(20) NOT NULL,
		CNTNR_NM VARCHAR2(255),
		CNTNR_DC VARCHAR2(2000),
		RMI_PORT VARCHAR2(20),
		MBSC_CNNC_TIME NUMBER(10 , 0),
		CNTNR_STTUS NUMBER(10 , 0),
		CNNC_MXMM_CO NUMBER(10 , 0),
		JNDI_PORT VARCHAR2(20)
	);
	
ALTER TABLE OE2TNCNTNRINFO ADD CONSTRAINT OE2TNCNTNRINFO_PK PRIMARY KEY (CNTNR_SN);

ALTER TABLE OE2TNCNTNRINFO ADD CONSTRAINT OE2TNCNTNRINFO_FK1 FOREIGN KEY (SERVER_ID)
	REFERENCES OE2TNMNTRGSERVERINFO (SERVER_ID);

CREATE INDEX OE2TNCNTNRINFO_FK1 ON OE2TNCNTNRINFO (SERVER_ID);

/* 3.어플리케이션 정보 테이블 */

CREATE TABLE OE2TNAPLCTNINFO (
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		APLCTN_NM VARCHAR2(255) NOT NULL,
		APLCTN_DC VARCHAR2(2000),
		MNTRNG_AT VARCHAR2(1),
		CALL_TRACE_AT VARCHAR2(1),
		ERROR_MNTRNG_AT VARCHAR2(1),
		JDBC_MNTRNG_AT VARCHAR2(1),
		RMI_PORT VARCHAR2(20),
		SETUP_FILE_LC VARCHAR2(255),
		LWET_THRHLD NUMBER(10 , 0),
		USER_MNTRNG_AT VARCHAR2(1),
		TRANSMIS_CYCLE NUMBER(10 , 0),
		APLCTN_KOREAN_NM VARCHAR2(1024)
	);
	
ALTER TABLE OE2TNAPLCTNINFO ADD CONSTRAINT OE2TNAPLCTNINFO_PK PRIMARY KEY (CNTNR_SN, APLCTN_NM);

ALTER TABLE OE2TNAPLCTNINFO ADD CONSTRAINT OE2TNAPLCTNINFO_FK1 FOREIGN KEY (CNTNR_SN)
	REFERENCES OE2TNCNTNRINFO (CNTNR_SN);
	
CREATE INDEX OE2TNAPLCTNINFO_FK1 ON OE2TNAPLCTNINFO (CNTNR_SN);

/* 4.MBean Client 설정 테이블 생성 */

CREATE TABLE OE2TNMBCLIENT (
		SN NUMBER(5 , 0) NOT NULL,
		CNTNR_SN NUMBER(10 , 0) NOT NULL,
		MODEL_MNTRNG VARCHAR2(1),
		MODEL_MNTRNG_CYCLE NUMBER(10 , 0),
		SCHDUL_MNTRNG VARCHAR2(1),
		SCHDUL_MNTRNG_CYCLE NUMBER(10 , 0),
		OPERSYSM_MNTRNG VARCHAR2(1),
		OPERSYSM_MNTRNG_CYCLE NUMBER(10 , 0),
		MEMORY_MNTRNG VARCHAR2(1),
		MEMORY_MNTRNG_CYCLE NUMBER(10 , 0),
		CLASS_MNTRNG VARCHAR2(1),
		CLASS_MNTRNG_CYCLE NUMBER(10 , 0),
		THREAD_MNTRNG VARCHAR2(1),
		THREAD_MNTRNG_CYCLE NUMBER(10 , 0),
		JDBCPOOL_MNTRNG VARCHAR2(1),
		JDBCPOOL_MNTRNG_CYCLE NUMBER(10 , 0),
		SESION_MNTRNG VARCHAR2(1),
		SESION_MNTRNG_CYCLE NUMBER(10 , 0),
		START_TIME VARCHAR2(20) NOT NULL,
		END_TIME VARCHAR2(20),
		CPU_THRHLD NUMBER(5 , 0),
		HPMORY_THRHLD NUMBER(5 , 0),
		NNHPMORY_THRHLD NUMBER(5 , 0),
		SESION_THRHLD NUMBER(5 , 0),
		THREAD_THRHLD NUMBER(5 , 0),
		JDBC_THRHLD NUMBER(5 , 0)
	);
	
ALTER TABLE OE2TNMBCLIENT ADD CONSTRAINT OE2TNMBCLIENT_PK PRIMARY KEY (SN);

ALTER TABLE OE2TNMBCLIENT ADD CONSTRAINT OE2TNMBCLIENT_FK1 FOREIGN KEY (CNTNR_SN)
	REFERENCES OE2TNCNTNRINFO (CNTNR_SN);
	
CREATE INDEX OE2TNMBCLIENT_FK1 ON OE2TNMBCLIENT (CNTNR_SN);	

/* 5.사용자 정보 테이블 */

ALTER TABLE OE2TNUSERINFO DROP CONSTRAINT OE2TNUSERINFO_PK;

DROP TABLE OE2TNUSERINFO;

CREATE TABLE OE2TNUSERINFO (
		USID VARCHAR2(20) NOT NULL,
		USER_NM VARCHAR2(60),
		EMAIL_ADRES VARCHAR2(50),
		MBTLNUM VARCHAR2(20),
		PASSWORD VARCHAR2(2000),
		MONITORING_USER_ROLE VARCHAR2(2)
	);
	
ALTER TABLE OE2TNUSERINFO ADD CONSTRAINT OE2TNUSERINFO_PK PRIMARY KEY (USID);

/* 6.DB서비스 정보 테이블 */

ALTER TABLE OE2TNDBINFO DROP CONSTRAINT OE2TNDBINFO_PK;

DROP TABLE OE2TNDBINFO;

CREATE TABLE OE2TNDBINFO (
		SYS_DB_ID VARCHAR2(20) NOT NULL,
		SERVER_NM VARCHAR2(60),
		DATA_SOURC_NM VARCHAR2(60),
		DBMS_KIND VARCHAR2(2),
		CNNC_URL VARCHAR2(250),
		USER_ID VARCHAR2(20),
		PASSWORD VARCHAR2(250),
		CECK_SQL VARCHAR2(250),
		SVC_STTUS VARCHAR2(2),
		ETC_DC VARCHAR2(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20)
	);
	
ALTER TABLE OE2TNDBINFO ADD CONSTRAINT OE2TNDBINFO_PK PRIMARY KEY (SYS_DB_ID);

/* 7.HTTP 서비스 정보 테이블 */

ALTER TABLE OE2TNHTTPINFO DROP CONSTRAINT OE2TNHTTPINFO_PK;

DROP TABLE OE2TNHTTPINFO;

CREATE TABLE OE2TNHTTPINFO (
		SYS_HTTP_ID VARCHAR2(20) NOT NULL,
		SERVER_NM VARCHAR2(60),
		SVC_NM VARCHAR2(60),
		SVC_URL VARCHAR2(250),
		SVC_KIND VARCHAR2(2),
		SVC_STTUS VARCHAR2(2),
		ETC_DC VARCHAR2(1000),
		USE_AT CHAR(1),
		EMAIL_SNDNG_AT CHAR(1),
		SMS_SNDNG_AT CHAR(1),
		EMAIL_RECPTN_AT CHAR(1),
		SMS_RECPTN_AT CHAR(1),
		FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20)
	);
	
ALTER TABLE OE2TNHTTPINFO ADD CONSTRAINT OE2TNHTTPINFO_PK PRIMARY KEY (SYS_HTTP_ID);

/* 8.프로세스정보 테이블 */

ALTER TABLE OE2TNPROCSINFO DROP CONSTRAINT OE2TNPROCSINFO_PK;

DROP TABLE OE2TNPROCSINFO;

CREATE TABLE OE2TNPROCSINFO (
		SYS_PROCS_ID VARCHAR2(20) NOT NULL,
		SERVER_NM VARCHAR2(60),
		PROCS_NM VARCHAR2(60),
		MNTRNG_TRGET_PROCS VARCHAR2(60),
		MNTRNG_TRGET_IP VARCHAR2(60),
		MNTRNG_TRGET_PORT VARCHAR2(10),
		MNTRNG_TRGET_CONTEXT VARCHAR2(60),
		MNTRNG_TRGET_AGT_URL VARCHAR2(250),
		SVC_STTUS VARCHAR2(2),
		ETC_DC VARCHAR2(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20)
	);		
	
ALTER TABLE OE2TNPROCSINFO ADD CONSTRAINT OE2TNPROCSINFO_PK PRIMARY KEY (SYS_PROCS_ID);	

/* 9.네트워크 서비스 정보 테이블 */

ALTER TABLE OE2TNNTWRKINFO DROP CONSTRAINT OE2TNNTWRKINFO_PK;

DROP TABLE OE2TNNTWRKINFO;

CREATE TABLE OE2TNNTWRKINFO (
		SYS_NTWRK_ID VARCHAR2(20) NOT NULL,
		SVC_IP VARCHAR2(23) NOT NULL,
		SVC_PORT VARCHAR2(10) NOT NULL,
		SVC_NM VARCHAR2(255) NOT NULL,
		SVC_STTUS VARCHAR2(2),
		ETC_DC VARCHAR2(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20)
	);
	
ALTER TABLE OE2TNNTWRKINFO ADD CONSTRAINT OE2TNNTWRKINFO_PK PRIMARY KEY (SYS_NTWRK_ID, SVC_IP, SVC_PORT);

/* 10.파일시스템 정보 테이블 */

ALTER TABLE OE2TNFILESYSINFO DROP CONSTRAINT OE2TNFILESYSINFO_PK;

DROP TABLE OE2TNFILESYSINFO;

CREATE TABLE OE2TNFILESYSINFO (
		FILE_SYS_ID VARCHAR2(20) NOT NULL,
		SERVER_NM VARCHAR2(60),
		OPERSYSM_TY VARCHAR2(60),
		FILE_SYS_NM VARCHAR2(60),
		FILE_SYS_MANAGE_NM VARCHAR2(255),
		FILE_SYS_MG NUMBER(8 , 0) NOT NULL,
		FILE_SYS_THRHLD NUMBER(8 , 0) NOT NULL,
		FILE_SYS_USEQTY NUMBER(8 , 0) NOT NULL,
		FILE_SYS_STTUS VARCHAR2(15),
		ETC_DC VARCHAR2(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20),
		MNTRNG_TRGET_AGT_URL VARCHAR2(250)
	);
	
ALTER TABLE OE2TNFILESYSINFO ADD CONSTRAINT OE2TNFILESYSINFO_PK PRIMARY KEY (FILE_SYS_ID);

/* 11.송수신 정보 테이블 */

ALTER TABLE OE2TNTRSMRCVINFO DROP CONSTRAINT OE2TNTRSMRCVINFO_PK;

DROP TABLE OE2TNTRSMRCVINFO;

CREATE TABLE OE2TNTRSMRCVINFO (
		CNTC_ID CHAR(8) NOT NULL,
		CNTC_NM VARCHAR2(100),
		TEST_CLASS_NM VARCHAR2(1000),
		PROVD_INSTT_NM VARCHAR2(100),
		REQUST_INSTT_NM VARCHAR2(100),
		SVC_STTUS CHAR(2),
		FRST_REGISTER_PNTTM DATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20),
		USE_AT CHAR(1)
	);
	
ALTER TABLE OE2TNTRSMRCVINFO ADD CONSTRAINT OE2TNTRSMRCVINFO_PK PRIMARY KEY (CNTC_ID);

/*==============================================================*/
/* Application Agent Monitoring	테이블 : 5                      */
/*==============================================================*/


/* 1.레이어정보 테이블 */

ALTER TABLE OE2TNLYRINFO DROP CONSTRAINT OE2TNLYRINFO_PK;

DROP TABLE OE2TNLYRINFO;

drop sequence SQ_OE2TNLYRINFO_LYR_SN;

create sequence "SQ_OE2TNLYRINFO_LYR_SN"
increment by 1
start with 1
 maxvalue 9999999999
 minvalue 0
nocycle
order;

CREATE TABLE OE2TNLYRINFO (
		LYR_SN NUMBER(10 , 0) NOT NULL,
		HST_NM VARCHAR2(20) NOT NULL,
		APLCTN_NM VARCHAR2(255) NOT NULL,
		LYR_NM VARCHAR2(50) NOT NULL,
		LYR_PD NUMBER(20 , 0),
		INPUT_DT DATE NOT NULL
	);
	
ALTER TABLE OE2TNLYRINFO ADD CONSTRAINT OE2TNLYRINFO_PK PRIMARY KEY (LYR_SN);

CREATE INDEX OE2TNLYRINFO_I01 ON OE2TNLYRINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 2.실행 정보 테이블 */

ALTER TABLE OE2TNEXECUTINFO DROP CONSTRAINT OE2TNEXECUTINFO_PK;	

DROP TABLE OE2TNEXECUTINFO;

drop sequence SQ_OE2TNEXECUTINFO_EXECUT_SN;

create sequence "SQ_OE2TNEXECUTINFO_EXECUT_SN"
increment by 1
start with 1
 maxvalue 9999999999
 minvalue 0
nocycle
order;

CREATE TABLE OE2TNEXECUTINFO (
		EXECUT_SN NUMBER(10 , 0) NOT NULL,
		HST_NM VARCHAR2(20) NOT NULL,
		APLCTN_NM VARCHAR2(255) NOT NULL,
		LYR_NM VARCHAR2(50) NOT NULL,
		CLASS_NM VARCHAR2(255) NOT NULL,
		EXECUT_CN VARCHAR2(4000) NOT NULL,
		LYR_DETAIL VARCHAR2(300),
		EXECUT_CO NUMBER(20 , 0),
		TOT_INCLS_TIME NUMBER(20 , 0),
		TOT_EXCL_TIME NUMBER(20 , 0),
		MXMM_INCLS_TIME NUMBER(20 , 0),
		MUMM_INCLS_TIME NUMBER(20 , 0),
		MXMM_EXCL_TIME NUMBER(20 , 0),
		MUMM_EXCL_TIME NUMBER(20 , 0),
		FRST_EXECUT_TIME NUMBER(20 , 0),
		LAST_EXECUT_TIME NUMBER(20 , 0),
		INCLS_FRST_EXECUT_TIME NUMBER(20 , 0),
		INCLS_LAST_EXECUT_TIME NUMBER(20 , 0),
		EXCL_FRST_EXECUT_TIME NUMBER(20 , 0),
		EXCL_LAST_EXECUT_TIME NUMBER(20 , 0),
		INPUT_DT DATE NOT NULL
	);
	
ALTER TABLE OE2TNEXECUTINFO ADD CONSTRAINT OE2TNEXECUTINFO_PK PRIMARY KEY (EXECUT_SN);	
	
CREATE INDEX OE2TNEXECUTINFO_I01 ON OE2TNEXECUTINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 3.사용정보 테이블 */

ALTER TABLE OE2TNUSEINFO DROP CONSTRAINT OE2TNUSEINFO_PK;

DROP TABLE OE2TNUSEINFO;

drop sequence SQ_OE2TNUSEINFO_USE_SN;

create sequence "SQ_OE2TNUSEINFO_USE_SN"
increment by 1
start with 1
 maxvalue 9999999999
 minvalue 0
nocycle
order;

CREATE TABLE OE2TNUSEINFO (
		USE_SN NUMBER(10 , 0) NOT NULL,
		HST_NM VARCHAR2(20) NOT NULL,
		APLCTN_NM VARCHAR2(255) NOT NULL,
		INPUT_DT DATE NOT NULL,
		CALL_DT DATE,
		BRWSR_TY VARCHAR2(50),
		BRWSR_VER VARCHAR2(50),
		OPERSYSM_TY VARCHAR2(50),
		OPERSYSM_VER VARCHAR2(40),
		SYS_INFO VARCHAR2(250),
		JOB_INFO VARCHAR2(250),
		ETC_INFO VARCHAR2(250),
		USID VARCHAR2(50),
		INADRS_INFO VARCHAR2(255),
		REFRN_URL VARCHAR2(1024)
	);
	
ALTER TABLE OE2TNUSEINFO ADD CONSTRAINT OE2TNUSEINFO_PK PRIMARY KEY (USE_SN);

CREATE INDEX OE2TNUSEINFO_I01 ON OE2TNUSEINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 4.호출정보 테이블 */

ALTER TABLE OE2TNCALLINFO DROP CONSTRAINT OE2TNCALLINFO_PK;

DROP TABLE OE2TNCALLINFO;

drop sequence SQ_OE2TNCALLINFO_CALL_SN;	

create sequence "SQ_OE2TNCALLINFO_CALL_SN"
increment by 1
start with 1
 maxvalue 9999999999
 minvalue 0
nocycle
order;

CREATE TABLE OE2TNCALLINFO (
		CALL_SN NUMBER(10 , 0) NOT NULL,
		HST_NM VARCHAR2(20) NOT NULL,
		APLCTN_NM VARCHAR2(255) NOT NULL,
		CALL_RELATE BLOB NOT NULL,
		INPUT_DT DATE NOT NULL
	);
	
ALTER TABLE OE2TNCALLINFO ADD CONSTRAINT OE2TNCALLINFO_PK PRIMARY KEY (CALL_SN);

CREATE INDEX OE2TNCALLINFO_I01 ON OE2TNCALLINFO (INPUT_DT, APLCTN_NM, HST_NM);	

/* 5.오류정보 테이블 */

ALTER TABLE OE2TNEXCPINFO DROP CONSTRAINT OE2TNEXCPINFO_PK;

DROP TABLE OE2TNEXCPINFO;

drop sequence SQ_OE2TNEXCPINFO_EXCP_SN;

create sequence "SQ_OE2TNEXCPINFO_EXCP_SN"
increment by 1
start with 1
 maxvalue 9999999999
 minvalue 0
nocycle
order;

CREATE TABLE OE2TNEXCPINFO (
		EXCP_SN NUMBER(10 , 0) NOT NULL,
		HST_NM VARCHAR2(20) NOT NULL,
		APLCTN_NM VARCHAR2(255) NOT NULL,
		INPUT_DT DATE NOT NULL,
		EXCP_DT DATE,
		EXCP_MSSAGE VARCHAR2(1000),
		EXCP_TRACE CLOB,
		CLASS_NM VARCHAR2(255),
		METHOD_NM VARCHAR2(255),
		SYS_INFO VARCHAR2(250),
		JOB_INFO VARCHAR2(250),
		ETC_INFO VARCHAR2(250),
		USID VARCHAR2(50)
	);
	
ALTER TABLE OE2TNEXCPINFO ADD CONSTRAINT OE2TNEXCPINFO_PK PRIMARY KEY (EXCP_SN);

CREATE INDEX OE2TNEXCP_I01 ON OE2TNEXCPINFO (INPUT_DT, APLCTN_NM, HST_NM);	

/*==============================================================*/
/* Common Table  테이블 : 3	                       			        */
/*==============================================================*/

/* 1.Id Gen 테이블 */

ALTER TABLE OE2TNIDS DROP CONSTRAINT OE2TNIDS_PK;

DROP TABLE OE2TNIDS;

CREATE TABLE OE2TNIDS (
		TABLE_NAME VARCHAR2(16) NOT NULL,
		NEXT_ID NUMBER(30 , 0) NOT NULL
	);
	
ALTER TABLE OE2TNIDS ADD CONSTRAINT OE2TNIDS_PK PRIMARY KEY (TABLE_NAME);

/* 2.공통코드 테이블 */

ALTER TABLE OE2TCCMMNCODE DROP CONSTRAINT OE2TCCMMNCODE_PK;

DROP TABLE OE2TCCMMNCODE;

CREATE TABLE OE2TCCMMNCODE (
		CODE_ID VARCHAR2(6) NOT NULL,
		CODE_ID_NM VARCHAR2(180),
		CODE_ID_DC VARCHAR2(600),
		CL_CODE CHAR(3),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATE,
		FRST_REGISTER_ID VARCHAR2(20),
		LAST_UPDUSR_PNTTM DATE,
		LAST_UPDUSR_ID VARCHAR2(20)
	);
	
ALTER TABLE OE2TCCMMNCODE ADD CONSTRAINT OE2TCCMMNCODE_PK PRIMARY KEY (CODE_ID);

/* 3.공통코드 상세테이블 */		

ALTER TABLE OE2TCCMMNDETAILCODE DROP CONSTRAINT OE2TCCMMNDETAILCODE_PK;

DROP TABLE OE2TCCMMNDETAILCODE;

CREATE TABLE OE2TCCMMNDETAILCODE (
		CODE_ID VARCHAR2(6) NOT NULL,
		CODE VARCHAR2(15) NOT NULL,
		CODE_NM VARCHAR2(60),
		CODE_DC VARCHAR2(200),
		USE_AT CHAR(1)
	);
	
ALTER TABLE OE2TCCMMNDETAILCODE ADD CONSTRAINT OE2TCCMMNDETAILCODE_PK PRIMARY KEY (CODE_ID, CODE);

/*==============================================================*/
/* Statistic Table  (개발중 12개 테이블)                        */
/*==============================================================*/

DROP TABLE OE2TNJDBCINFODAYSTATS;

DROP TABLE OE2TNJDBCINFOHOUSTATS;

DROP TABLE OE2TNJDBCINFOMINSTATS;

DROP TABLE OE2TNJDBCINFOMONSTATS;
  
DROP TABLE OE2TNMORYINFODAYSTATS;

DROP TABLE OE2TNMORYINFOHOUSTATS;

DROP TABLE OE2TNMORYINFOMINSTATS;

DROP TABLE OE2TNMORYINFOMONSTATS;

DROP TABLE OE2TNTHREADINFODAYSTATS;

DROP TABLE OE2TNTHREADINFOHOUSTATS;

DROP TABLE OE2TNTHREADINFOMINSTATS;

DROP TABLE OE2TNTHREADINFOMONSTATS;



CREATE TABLE OE2TNJDBCINFODAYSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		JDBC_NM VARCHAR2(50),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		JDBC_THRHLD NUMBER(22 , 0)
	);
	
CREATE TABLE OE2TNJDBCINFOHOUSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		JDBC_NM VARCHAR2(50),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		JDBC_THRHLD NUMBER(22 , 0)
	);	
	
CREATE TABLE OE2TNJDBCINFOMINSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		JDBC_NM VARCHAR2(50),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		JDBC_THRHLD NUMBER(22 , 0)
	);	

CREATE TABLE OE2TNJDBCINFOMONSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		JDBC_NM VARCHAR2(50),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		JDBC_THRHLD NUMBER(22 , 0)
	);
	
CREATE TABLE OE2TNMORYINFODAYSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		HPMORY_THRHLD NUMBER(22 , 0),
		MNR_GC_CO NUMBER(22 , 0),
		MNR_GC_TM NUMBER(22 , 0),
		MJR_GC_CO NUMBER(22 , 0),
		MJR_GC_TM NUMBER(22 , 0)
	);
	
CREATE TABLE OE2TNMORYINFOHOUSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		HPMORY_THRHLD NUMBER(22 , 0),
		MNR_GC_CO NUMBER(22 , 0),
		MNR_GC_TM NUMBER(22 , 0),
		MJR_GC_CO NUMBER(22 , 0),
		MJR_GC_TM NUMBER(22 , 0)
	);	

CREATE TABLE OE2TNMORYINFOMINSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		HPMORY_THRHLD NUMBER(22 , 0),
		MNR_GC_CO NUMBER(22 , 0),
		MNR_GC_TM NUMBER(22 , 0),
		MJR_GC_CO NUMBER(22 , 0),
		MJR_GC_TM NUMBER(22 , 0)
	);

CREATE TABLE OE2TNMORYINFOMONSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		HPMORY_THRHLD NUMBER(22 , 0),
		MNR_GC_CO NUMBER(22 , 0),
		MNR_GC_TM NUMBER(22 , 0),
		MJR_GC_CO NUMBER(22 , 0),
		MJR_GC_TM NUMBER(22 , 0)
	);
	
CREATE TABLE OE2TNTHREADINFODAYSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		THREAD_THRHLD NUMBER(22 , 0)
	);	

CREATE TABLE OE2TNTHREADINFOHOUSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		THREAD_THRHLD NUMBER(22 , 0)
	);

CREATE TABLE OE2TNTHREADINFOMINSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		THREAD_THRHLD NUMBER(22 , 0)
	);

CREATE TABLE OE2TNTHREADINFOMONSTATS (
		CUR_TIME TIMESTAMP(6),
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR2(60),
		CNTNR_SN NUMBER(10 , 0),
		CNTNR_NM VARCHAR2(60),
		AVRG_CUR_CO NUMBER(22 , 0),
		MXMM_CUR_CO NUMBER(22 , 0),
		THREAD_THRHLD NUMBER(22 , 0)
	);	