
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JbossMBean {
    public static void main(String[] args) throws IOException, NamingException, MalformedObjectNameException, NullPointerException, InterruptedException {
        
        // args[0] : server IP
        // args[1] : rmi port
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://"+args[0]+":"+args[1]+"/jmxrmi");

        JMXConnector conn = javax.management.remote.JMXConnectorFactory.connect(url, null); 
        MBeanServerConnection mbsc = conn.getMBeanServerConnection();    
        Set jvmMBean = mbsc.queryMBeans(null, null);

        for (Iterator i = jvmMBean.iterator(); i.hasNext();) {
              ObjectName objName = ((ObjectInstance) i.next()).getObjectName();
              System.out.println("[JMX MBean] " + objName);      
        }
        
        
        // args[0] : server IP
        // args[1] : rmi port
        // args[2] : jndi port default: 1066
        // args[3] : jboss jmx-console user id 
        // args[4] : jboss jmx-console password
        Hashtable props = new Hashtable();
        props.put(InitialContext.PROVIDER_URL, "jnp://"+args[0]+":"+args[2]);
        props.put(InitialContext.INITIAL_CONTEXT_FACTORY, "org.jboss.security.jndi.JndiLoginInitialContextFactory");
//"org.jnp.interfaces.NamingContextFactory");
                props.put(InitialContext.SECURITY_PRINCIPAL, args[3]);
        props.put(InitialContext.SECURITY_CREDENTIALS, args[4]);        
	MBeanServerConnection mconn =(MBeanServerConnection)new InitialContext(props).lookup("jmx/invoker/RMIAdaptor");
         
      
        Set jvmMBeans_tc = mconn.queryMBeans(null, null);

        String mbean = null;
        for (Iterator i = jvmMBeans_tc.iterator(); i.hasNext();) {
              ObjectName objName = ((ObjectInstance) i.next()).getObjectName();
              mbean = objName.toString();
              System.out.println("[jboss MBean] " + objName);      
        }
        
    }
    
}

