import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WebLogicMBean {
    public static void main(String[] args) throws IOException, NamingException, MalformedObjectNameException, NullPointerException, InterruptedException {

				// args[0] : server IP
				// args[1] : weblogic t3 port default: 7001
      
        String protocol = "t3"; 
        int port = portInteger.intValue(); 
        String jndiroot = "/jndi/"; 
        String mserver = "weblogic.management.mbeanservers.domainruntime"; 
        JMXServiceURL serviceURL = new JMXServiceURL(protocol,args[0] , args[1], 
        jndiroot + mserver); 
        Hashtable<String,String> h = new Hashtable<String,String>(); 
        h.put(Context.SECURITY_PRINCIPAL, "weblogic"); 
        h.put(Context.SECURITY_CREDENTIALS, "weblogic"); 
        h.put(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES, 
        "weblogic.management.remote"); 
        JMXConnector  connector = JMXConnectorFactory.connect(serviceURL, h); 
        MBeanServerConnection mbsc = connector.getMBeanServerConnection(); 
            
        Set jvmMBeans_tc = mbsc.queryMBeans(null, null);

        for (Iterator i = jvmMBeans_tc.iterator(); i.hasNext();) {
              ObjectName objName = ((ObjectInstance) i.next()).getObjectName();
              System.out.println("[weblogic MBean] " + objName);      
        }
    }

}

