import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;

//  Tomcat Mbean can be connected through JMXConnectoryFactory's connect method.
public class JvmMBean
 {
    public static void main(String[] args) throws IOException, NamingException, MalformedObjectNameException, NullPointerException, InterruptedException {
        // args[0] : server IP
        // args[1] : rmi port
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://"+args[0]+":"+args[1]+"/jmxrmi");

        JMXConnector conn = javax.management.remote.JMXConnectorFactory.connect(url, null); 
        MBeanServerConnection mbsc = conn.getMBeanServerConnection();    
        Set jvmMBean = mbsc.queryMBeans(null, null);

        for (Iterator i = jvmMBean.iterator(); i.hasNext();) {
              ObjectName objName = ((ObjectInstance) i.next()).getObjectName();
              System.out.println("[JMX MBean] " + objName);      
        }
        
        

    }
}
