/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import org.hibernate.ejb.event.CallbackHandlerConsumer;
import org.hibernate.ejb.event.EntityCallbackHandler;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;

public class EJB3PostUpdateEventListener
implements PostUpdateEventListener,
CallbackHandlerConsumer,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener {
    EntityCallbackHandler callbackHandler;

    public void setCallbackHandler(EntityCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public EJB3PostUpdateEventListener() {
    }

    public EJB3PostUpdateEventListener(EntityCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    private void handlePostUpdate(Object entity, EventSource source) {
        EntityEntry entry = (EntityEntry)source.getPersistenceContext().getEntityEntries().get(entity);
        if (Status.DELETED != entry.getStatus()) {
            this.callbackHandler.postUpdate(entity);
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }
}

