/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lbel;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.lbel.ScanError;
import org.apache.log4j.lbel.Token;

class TokenStream {
    private static Map keywordMap = new HashMap();
    StreamTokenizer tokenizer;
    int token;
    Token current;
    Reader reader;

    public TokenStream(Reader reader) {
        this.reader = reader;
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(32, 32);
        this.tokenizer.whitespaceChars(9, 9);
        this.tokenizer.whitespaceChars(10, 10);
        this.tokenizer.whitespaceChars(13, 13);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.parseNumbers();
        this.tokenizer.ordinaryChar(46);
    }

    public Token getCurrent() {
        return this.current;
    }

    public void next() throws IOException, ScanError {
        if (this.token != -1) {
            this.token = this.tokenizer.nextToken();
            switch (this.token) {
                case -1: {
                    this.current = new Token(1000);
                    break;
                }
                case -2: {
                    double nval = this.tokenizer.nval;
                    this.current = new Token(21, new Long((long)nval));
                    break;
                }
                case -3: {
                    String txt = this.tokenizer.sval;
                    String lowerCaseTxt = txt.toLowerCase();
                    Token result = (Token)keywordMap.get(lowerCaseTxt);
                    if (result != null) {
                        this.current = result;
                        break;
                    }
                    this.current = new Token(20, this.tokenizer.sval);
                    break;
                }
                case 34: 
                case 39: {
                    this.current = this.scanLiteral(this.token);
                    break;
                }
                case 46: {
                    this.current = new Token(200, ".");
                    break;
                }
                case 62: {
                    int token2 = this.tokenizer.nextToken();
                    if (token2 == 61) {
                        this.current = new Token(30, ">=");
                        break;
                    }
                    this.current = new Token(30, ">");
                    this.tokenizer.pushBack();
                    break;
                }
                case 60: {
                    int token2 = this.tokenizer.nextToken();
                    if (token2 == 61) {
                        this.current = new Token(30, "<=");
                        break;
                    }
                    this.current = new Token(30, "<");
                    this.tokenizer.pushBack();
                    break;
                }
                case 61: {
                    this.current = new Token(30, "=");
                    break;
                }
                case 126: {
                    this.current = new Token(30, "~");
                    break;
                }
                case 33: {
                    int token2 = this.tokenizer.nextToken();
                    if (token2 == 61) {
                        this.current = new Token(30, "!=");
                        break;
                    }
                    if (token2 == 126) {
                        this.current = new Token(30, "!~");
                        break;
                    }
                    throw new ScanError("Unrecogized token " + this.token + ". The '!' character must be followed by = or '~'");
                }
                case 40: {
                    this.current = new Token(40);
                    break;
                }
                case 41: {
                    this.current = new Token(41);
                    break;
                }
                default: {
                    throw new ScanError("Unrecogized token [" + (char)this.token + "]");
                }
            }
        }
    }

    Token scanLiteral(int startChar) {
        StringBuffer buf = new StringBuffer();
        try {
            int in = 0;
            while (in != -1) {
                in = this.reader.read();
                if (in != startChar) {
                    switch (in) {
                        case 10: 
                        case 13: {
                            break;
                        }
                        default: {
                            buf.append((char)in);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Token(20, buf.toString());
    }

    static {
        keywordMap.put("true", new Token(1));
        keywordMap.put("false", new Token(2));
        keywordMap.put("not", new Token(12));
        keywordMap.put("and", new Token(11));
        keywordMap.put("or", new Token(10));
        keywordMap.put("childof", new Token(30, "childof"));
        keywordMap.put("logger", new Token(100, "logger"));
        keywordMap.put("message", new Token(110, "message"));
        keywordMap.put("level", new Token(120, "level"));
        keywordMap.put("method", new Token(180, "method"));
        keywordMap.put("class", new Token(170, "class"));
        keywordMap.put("thread", new Token(140, "thread"));
        keywordMap.put("property", new Token(150, "property"));
        keywordMap.put("date", new Token(160, "date"));
        keywordMap.put("null", new Token(190, "null"));
    }
}

