/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.configuration.jsse.spring.TLSServerParametersConfig;
import org.apache.cxf.configuration.security.TLSServerParametersType;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JettyHTTPServerEngineBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String portStr = element.getAttribute("port");
        bean.addPropertyValue("port", (Object)portStr);
        String continuationsStr = element.getAttribute("continuationsEnabled");
        if (continuationsStr != null && continuationsStr.length() > 0) {
            bean.addPropertyValue("continuationsEnabled", (Object)continuationsStr);
        }
        ConstructorArgumentValues.ValueHolder busValue = ctx.getContainingBeanDefinition().getConstructorArgumentValues().getArgumentValue(0, Bus.class);
        bean.addPropertyValue("bus", busValue.getValue());
        try {
            Element elem = DOMUtils.getFirstElement((Node)element);
            while (elem != null) {
                String name = elem.getLocalName();
                if ("tlsServerParameters".equals(name)) {
                    this.mapElementToJaxbPropertyFactory(elem, bean, "tlsServerParameters", JettyHTTPServerEngineBeanDefinitionParser.class, "createTLSServerParametersConfig", new Object[0]);
                } else if ("threadingParameters".equals(name)) {
                    this.mapElementToJaxbPropertyFactory(elem, bean, "threadingParameters", JettyHTTPServerEngineBeanDefinitionParser.class, "createThreadingParameters", new Object[0]);
                } else if ("tlsServerParametersRef".equals(name)) {
                    this.mapElementToJaxbPropertyFactory(elem, bean, "tlsServerParametersRef", JettyHTTPServerEngineBeanDefinitionParser.class, "createTLSServerParametersConfigRef", new Object[0]);
                } else if ("threadingParametersRef".equals(name)) {
                    this.mapElementToJaxbPropertyFactory(elem, bean, "threadingParametersRef", JettyHTTPServerEngineBeanDefinitionParser.class, "createThreadingParametersRef", new Object[0]);
                } else if ("connector".equals(name)) {
                    List list = ctx.getDelegate().parseListElement(elem, (BeanDefinition)bean.getBeanDefinition());
                    bean.addPropertyValue("connector", list.get(0));
                } else if ("handlers".equals(name)) {
                    List handlers = ctx.getDelegate().parseListElement(elem, (BeanDefinition)bean.getBeanDefinition());
                    bean.addPropertyValue("handlers", (Object)handlers);
                } else if ("sessionSupport".equals(name) || "reuseAddress".equals(name)) {
                    String text = elem.getTextContent();
                    bean.addPropertyValue(name, (Object)text);
                }
                elem = DOMUtils.getNextElement((Element)elem);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
        bean.setLazyInit(false);
    }

    private static ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        return params;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class getBeanClass(Element arg0) {
        return SpringJettyHTTPServerEngine.class;
    }

    public static TLSServerParametersConfig createTLSServerParametersConfig(String s) throws GeneralSecurityException, IOException {
        TLSServerParametersType parametersType = (TLSServerParametersType)JettyHTTPServerEngineBeanDefinitionParser.unmarshalFactoryString((String)s, TLSServerParametersType.class);
        return new TLSServerParametersConfig(parametersType);
    }

    public static String createTLSServerParametersConfigRef(String s) throws GeneralSecurityException, IOException {
        TLSServerParametersIdentifiedType parameterTypeRef = (TLSServerParametersIdentifiedType)JettyHTTPServerEngineBeanDefinitionParser.unmarshalFactoryString((String)s, TLSServerParametersIdentifiedType.class);
        return parameterTypeRef.getId();
    }

    public static ThreadingParameters createThreadingParameters(String s) {
        ThreadingParametersType parametersType = (ThreadingParametersType)JettyHTTPServerEngineBeanDefinitionParser.unmarshalFactoryString((String)s, ThreadingParametersType.class);
        return JettyHTTPServerEngineBeanDefinitionParser.toThreadingParameters(parametersType);
    }

    public static String createThreadingParametersRef(String s) {
        ThreadingParametersIdentifiedType parametersType = (ThreadingParametersIdentifiedType)JettyHTTPServerEngineBeanDefinitionParser.unmarshalFactoryString((String)s, ThreadingParametersIdentifiedType.class);
        return parametersType.getId();
    }

    public static class SpringJettyHTTPServerEngine
    extends JettyHTTPServerEngine
    implements ApplicationContextAware {
        String threadingRef;
        String tlsRef;

        public SpringJettyHTTPServerEngine(JettyHTTPServerEngineFactory fac, Bus bus, int port) {
            super(fac, bus, port);
        }

        public SpringJettyHTTPServerEngine() {
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)bus, (ApplicationContext)ctx);
                this.setBus(bus);
            }
        }

        public void setThreadingParametersRef(String s) {
            this.threadingRef = s;
        }

        public void setTlsServerParametersRef(String s) {
            this.tlsRef = s;
        }

        @PostConstruct
        public void finalizeConfig() throws GeneralSecurityException, IOException {
            if (this.tlsRef != null || this.threadingRef != null) {
                this.retrieveEngineFactory();
                if (this.threadingRef != null) {
                    this.setThreadingParameters(this.factory.getThreadingParametersMap().get(this.threadingRef));
                }
                if (this.tlsRef != null) {
                    this.setTlsServerParameters(this.factory.getTlsServerParametersMap().get(this.tlsRef));
                }
            }
            super.finalizeConfig();
        }
    }
}

