/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.jdbc;

import com.ibatis.common.jdbc.logging.ConnectionLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.sqlmap.engine.transaction.IsolationLevel;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JdbcTransaction
implements Transaction {
    private static final Log connectionLog = LogFactory.getLog(Connection.class);
    private DataSource dataSource;
    private Connection connection;
    private IsolationLevel isolationLevel = new IsolationLevel();

    public JdbcTransaction(DataSource ds, int isolationLevel) throws TransactionException {
        this.dataSource = ds;
        if (this.dataSource == null) {
            throw new TransactionException("JdbcTransaction initialization failed.  DataSource was null.");
        }
        this.isolationLevel.setIsolationLevel(isolationLevel);
    }

    private void init() throws SQLException, TransactionException {
        this.connection = this.dataSource.getConnection();
        if (this.connection == null) {
            throw new TransactionException("JdbcTransaction could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        this.isolationLevel.applyIsolationLevel(this.connection);
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        if (connectionLog.isDebugEnabled()) {
            this.connection = ConnectionLogProxy.newInstance(this.connection);
        }
    }

    public void commit() throws SQLException, TransactionException {
        if (this.connection != null) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException, TransactionException {
        if (this.connection != null) {
            this.connection.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException, TransactionException {
        if (this.connection != null) {
            try {
                this.isolationLevel.restoreIsolationLevel(this.connection);
            }
            finally {
                this.connection.close();
                this.connection = null;
            }
        }
    }

    public Connection getConnection() throws SQLException, TransactionException {
        if (this.connection == null) {
            this.init();
        }
        return this.connection;
    }
}

