/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cmmn.exception.manager;

import egovframework.rte.fdl.cmmn.exception.handler.ExceptionHandler;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.util.PathMatcher;

public abstract class AbsExceptionHandleManager {
    protected Log log = LogFactory.getLog(this.getClass());
    @Resource(name="messageSource")
    protected MessageSource messageSource;
    protected Exception ex;
    protected String thisPackageName;
    protected String[] patterns;
    protected ExceptionHandler[] handlers;
    protected PathMatcher pm;

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public void setHandlers(ExceptionHandler[] handlers) {
        this.handlers = handlers;
    }

    public void setPackageName(String canonicalName) {
        this.thisPackageName = canonicalName;
    }

    public String getPackageName() {
        return this.thisPackageName;
    }

    public void setException(Exception be) {
        this.ex = be;
    }

    public void setReqExpMatcher(PathMatcher pm) {
        this.pm = pm;
    }

    public boolean hasReqExpMatcher() {
        return this.enableMatcher();
    }

    public boolean enableMatcher() {
        return this.pm != null;
    }

    public boolean run(Exception exception) throws Exception {
        if (!this.enableMatcher()) {
            return false;
        }
        String[] stringArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (this.pm.match(pattern, this.thisPackageName)) {
                ExceptionHandler[] exceptionHandlerArray = this.handlers;
                int n3 = this.handlers.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExceptionHandler eh = exceptionHandlerArray[n4];
                    eh.occur(exception, this.getPackageName());
                    ++n4;
                }
                break;
            }
            ++n2;
        }
        return true;
    }
}

