/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class BlobAccessor
extends Accessor {
    static final int maxLength = 4000;

    BlobAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 113, 113, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    BlobAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 113, 113, s, false);
        this.initForDescribe(113, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 4000;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    Object getObject(int n) throws SQLException {
        return this.getBLOB(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getBLOB(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getBLOB(n);
    }

    BLOB getBLOB(int n) throws SQLException {
        BLOB bLOB = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            bLOB = new BLOB(this.statement.connection, byArray);
        }
        return bLOB;
    }

    InputStream getAsciiStream(int n) throws SQLException {
        BLOB bLOB = this.getBLOB(n);
        if (bLOB == null) {
            return null;
        }
        return bLOB.asciiStreamValue();
    }

    Reader getCharacterStream(int n) throws SQLException {
        BLOB bLOB = this.getBLOB(n);
        if (bLOB == null) {
            return null;
        }
        return bLOB.characterStreamValue();
    }

    InputStream getBinaryStream(int n) throws SQLException {
        BLOB bLOB = this.getBLOB(n);
        if (bLOB == null) {
            return null;
        }
        return bLOB.getBinaryStream();
    }

    byte[] privateGetBytes(int n) throws SQLException {
        return super.getBytes(n);
    }

    byte[] getBytes(int n) throws SQLException {
        BLOB bLOB = this.getBLOB(n);
        if (bLOB == null) {
            return null;
        }
        InputStream inputStream = bLOB.getBinaryStream();
        int n2 = bLOB.getBufferSize();
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byte[] byArray = new byte[n2];
        try {
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DatabaseError.throwSqlException(151);
        }
        if (bLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(bLOB);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

