/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.salt;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.salt.SaltGenerator;

public final class FixedByteArraySaltGenerator
implements SaltGenerator {
    private byte[] salt = null;

    public synchronized void setSalt(byte[] salt) {
        Validate.notNull((Object)salt, (String)"Salt cannot be set null");
        this.salt = ArrayUtils.clone((byte[])salt);
    }

    public byte[] generateSalt(int lengthBytes) {
        if (this.salt == null) {
            throw new EncryptionInitializationException("Salt has not been set");
        }
        if (this.salt.length < lengthBytes) {
            throw new EncryptionInitializationException("Requested salt larger than set");
        }
        return ArrayUtils.subarray((byte[])this.salt, (int)0, (int)lengthBytes);
    }

    public boolean includePlainSaltInEncryptionResults() {
        return false;
    }
}

