/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice;

import egovframework.rte.itl.integration.EgovIntegrationContext;
import egovframework.rte.itl.integration.EgovIntegrationNoSuchServiceException;
import egovframework.rte.itl.integration.EgovIntegrationService;
import egovframework.rte.itl.integration.EgovIntegrationServiceProvider;
import egovframework.rte.itl.integration.metadata.IntegrationDefinition;
import egovframework.rte.itl.integration.metadata.dao.IntegrationDefinitionDao;
import egovframework.rte.itl.integration.monitor.EgovIntegrationServiceMonitor;
import egovframework.rte.itl.integration.type.CircularInheritanceException;
import egovframework.rte.itl.integration.type.NoSuchTypeException;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.TypeLoader;
import egovframework.rte.itl.webservice.EgovWebService;
import egovframework.rte.itl.webservice.data.WebServiceClientDefinition;
import egovframework.rte.itl.webservice.data.WebServiceServerDefinition;
import egovframework.rte.itl.webservice.data.dao.WebServiceClientDefinitionDao;
import egovframework.rte.itl.webservice.data.dao.WebServiceServerDefinitionDao;
import egovframework.rte.itl.webservice.service.EgovWebServiceClassLoader;
import egovframework.rte.itl.webservice.service.MessageConverter;
import egovframework.rte.itl.webservice.service.impl.EgovWebServiceClientImpl;
import egovframework.rte.itl.webservice.service.impl.MessageConverterImpl;
import egovframework.rte.itl.webservice.service.impl.ServiceBridgeImpl;
import egovframework.rte.itl.webservice.service.impl.ServiceEndpointInfoImpl;
import egovframework.rte.itl.webservice.service.impl.ServiceEndpointInterfaceInfoImpl;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class EgovWebServiceContext
implements EgovIntegrationContext,
ApplicationContextAware {
    private Log LOG = LogFactory.getLog(this.getClass());
    protected String organizationId;
    protected String systemId;
    protected long defaultTimeout;
    protected IntegrationDefinitionDao integrationDefinitionDao;
    protected WebServiceClientDefinitionDao webServiceClientDefinitionDao;
    protected WebServiceServerDefinitionDao webServiceServerDefinitionDao;
    protected TypeLoader typeLoader;
    protected EgovWebServiceClassLoader classLoader;
    protected ApplicationContext applicationContext;
    protected MessageConverter messageConverter;
    protected Map<String, EgovWebService> serviceMap;
    protected List<ServerInfo> serverList;
    protected Bus bus;

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setIntegrationDefinitionDao(IntegrationDefinitionDao integrationDefinitionDao) {
        this.integrationDefinitionDao = integrationDefinitionDao;
    }

    public void setWebServiceClientDefinitionDao(WebServiceClientDefinitionDao webServiceClientDefinitionDao) {
        this.webServiceClientDefinitionDao = webServiceClientDefinitionDao;
    }

    public void setWebServiceServerDefinitionDao(WebServiceServerDefinitionDao webServiceServerDefinitionDao) {
        this.webServiceServerDefinitionDao = webServiceServerDefinitionDao;
    }

    public void setTypeLoader(TypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    public void setClassLoader(EgovWebServiceClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void init() throws IllegalArgumentException {
        this.LOG.debug((Object)"Initilaize EgovWebServiceContext");
        if (!StringUtils.hasText((String)this.organizationId)) {
            this.LOG.error((Object)("Argument 'organizationId' is null or has no text (organizationId = " + (this.organizationId == null ? "\"" : "") + this.organizationId + (this.organizationId == null ? "\"" : "") + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)this.systemId)) {
            this.LOG.error((Object)("Argument 'systemId' is null or has no text (systemId = " + (this.systemId == null ? "\"" : "") + this.systemId + (this.systemId == null ? "\"" : "") + ")"));
            throw new IllegalArgumentException();
        }
        if (this.integrationDefinitionDao == null) {
            this.LOG.error((Object)"Argument 'integrationDefinitionDao' is null");
            throw new IllegalArgumentException();
        }
        if (this.webServiceClientDefinitionDao == null) {
            this.LOG.error((Object)"Argument 'webServiceClientDefinitionDao' is null");
            throw new IllegalArgumentException();
        }
        if (this.webServiceServerDefinitionDao == null) {
            this.LOG.error((Object)"Argument 'webServiceServerDefinitionDao' is null");
            throw new IllegalArgumentException();
        }
        if (this.typeLoader == null) {
            this.LOG.error((Object)"Argument 'typeLoader' is null");
            throw new IllegalArgumentException();
        }
        if (this.classLoader == null) {
            this.LOG.error((Object)"Argument 'classLoader' is null");
            throw new IllegalArgumentException();
        }
        this.LOG.debug((Object)"Create MessageConverter");
        this.messageConverter = new MessageConverterImpl(this.classLoader);
        this.initServerInfo();
        this.initClient();
    }

    protected void initServerInfo() {
        this.LOG.debug((Object)"Initialzise Server Info");
        ArrayList<WebServiceServerDefinition> webServiceServerDefinitions = new ArrayList<WebServiceServerDefinition>();
        List integrationDefinitions = this.integrationDefinitionDao.getIntegrationDefinitionOfProvider(this.organizationId, this.systemId);
        this.LOG.debug((Object)"Scan IntegrationDefinitions");
        for (IntegrationDefinition integrationDefinition : integrationDefinitions) {
            this.LOG.debug((Object)("Create Service Info of IntegrationDefinition(" + integrationDefinition + ")"));
            if (integrationDefinition == null) {
                this.LOG.error((Object)"IntegrationDefinition is null");
                continue;
            }
            if (!integrationDefinition.isValid()) {
                this.LOG.error((Object)"IntegrationDefinition is invalid");
                continue;
            }
            if (!integrationDefinition.isUsing()) {
                this.LOG.info((Object)("IntegrationDefinition(" + integrationDefinition + ") is not usable"));
                continue;
            }
            if (!integrationDefinition.getProvider().isUsing()) {
                this.LOG.info((Object)("IntegrationDefinition(" + integrationDefinition + ")'s provider service is not usable"));
                continue;
            }
            WebServiceServerDefinition webServiceServerDefinition = this.webServiceServerDefinitionDao.getWebServiceServerDefinition(integrationDefinition.getProvider());
            if (webServiceServerDefinition == null) {
                this.LOG.error((Object)("WebServiceServerDefinition of IntegrationDefinition(" + integrationDefinition + ") does not exist."));
                continue;
            }
            if (!webServiceServerDefinition.isValid()) {
                this.LOG.error((Object)("WebServiceServerDefinition of IntegrationDefinition(" + integrationDefinition + ") is invalid"));
                continue;
            }
            if (webServiceServerDefinitions.contains(webServiceServerDefinition)) continue;
            webServiceServerDefinitions.add(webServiceServerDefinition);
        }
        this.LOG.debug((Object)"Create WebService Server Module");
        this.serverList = new ArrayList<ServerInfo>();
        for (WebServiceServerDefinition webServiceServerDefinition : webServiceServerDefinitions) {
            this.LOG.debug((Object)("webServiceServerDefinition = " + webServiceServerDefinition));
            RecordType requestType = null;
            try {
                requestType = (RecordType)this.typeLoader.getType(webServiceServerDefinition.getServiceDefinition().getRequestMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                this.LOG.error((Object)("RequestMessageType RecordType(id = \"" + webServiceServerDefinition.getServiceDefinition().getRequestMessageTypeId() + "\")'s definition does not exist."), (Throwable)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                this.LOG.error((Object)("RequestMessageType RecordType(id = \"" + webServiceServerDefinition.getServiceDefinition().getRequestMessageTypeId() + "\") has circular inheritance."), (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("RequestMesageType = " + requestType));
            RecordType responseType = null;
            try {
                responseType = (RecordType)this.typeLoader.getType(webServiceServerDefinition.getServiceDefinition().getResponseMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                this.LOG.error((Object)("ResponseMessageType RecordType(id = \"" + webServiceServerDefinition.getServiceDefinition().getResponseMessageTypeId() + "\")'s definition does not exist."), (Throwable)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                this.LOG.error((Object)("ResponseMessageType RecordType(id = \"" + webServiceServerDefinition.getServiceDefinition().getResponseMessageTypeId() + "\") has circular inheritance."), (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ResponseMessageType = " + responseType));
            ServiceEndpointInfoImpl serviceEndpointInfo = null;
            try {
                serviceEndpointInfo = new ServiceEndpointInfoImpl(webServiceServerDefinition, requestType, responseType);
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)"Cannot create ServiceEndpointInfoImpl", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ServiceEndpointInfo = " + serviceEndpointInfo));
            Class<?> serviceImplClass = null;
            try {
                serviceImplClass = this.classLoader.loadClass(serviceEndpointInfo);
            }
            catch (ClassNotFoundException e) {
                this.LOG.error((Object)"Cannot load ServerEndpoint Class", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ServiceEndpoint Class = " + serviceImplClass));
            Object serviceImpl = null;
            try {
                serviceImpl = serviceImplClass.newInstance();
            }
            catch (IllegalAccessException e) {
                this.LOG.error((Object)"Cannot instantiate ServiceEndpoint", (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                this.LOG.error((Object)"Cannot instantiate ServiceEndpoint", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ServiceEndpoint instance = " + serviceImpl));
            EgovIntegrationServiceProvider provider = null;
            try {
                provider = (EgovIntegrationServiceProvider)this.applicationContext.getBean(webServiceServerDefinition.getServiceDefinition().getServiceProviderBeanId());
            }
            catch (BeansException e) {
                this.LOG.error((Object)("Cannot get providerBean(id = \"" + webServiceServerDefinition.getServiceDefinition().getServiceProviderBeanId() + "\")"), (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("EgovIntegrationServiceProvider = " + provider));
            ServiceBridgeImpl serviceBridge = null;
            try {
                serviceBridge = new ServiceBridgeImpl(provider, serviceEndpointInfo, this.messageConverter);
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)"Cannot create ServiceBridge", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ServiceBridge = " + serviceBridge));
            Field fieldServiceBridge = null;
            String fieldName = this.classLoader.getFieldNameOfServiceBridge();
            try {
                fieldServiceBridge = serviceImplClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                this.LOG.error((Object)("ServiceEndpoint does not have the field(name = \"" + fieldName + "\")"), (Throwable)e);
                continue;
            }
            try {
                fieldServiceBridge.set(serviceImpl, serviceBridge);
            }
            catch (IllegalAccessException e) {
                this.LOG.error((Object)"Cannot set ServiceBridge to provider", (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)"Cannot set ServiceBridge to provider", (Throwable)e);
                continue;
            }
            catch (SecurityException e) {
                this.LOG.error((Object)"Cannot set ServiceBridge to provider", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)"Add new ServiceInfo");
            this.serverList.add(new ServerInfo(webServiceServerDefinition.getAddress(), serviceImpl));
        }
        this.LOG.debug((Object)"Finished Initializing Server Info");
    }

    protected void initClient() {
        this.LOG.debug((Object)"Initialize Client Info");
        this.serviceMap = new HashMap<String, EgovWebService>();
        List integrationDefinitions = this.integrationDefinitionDao.getIntegrationDefinitionOfConsumer(this.organizationId, this.systemId);
        for (IntegrationDefinition integrationDefinition : integrationDefinitions) {
            this.LOG.debug((Object)("Create Client Info of IntegrationDefinition(" + integrationDefinition + ")"));
            if (integrationDefinition == null) {
                this.LOG.error((Object)"IntegrationDefinition is null");
                continue;
            }
            if (!integrationDefinition.isValid()) {
                this.LOG.error((Object)"IntegrationDefinition is invalid");
                continue;
            }
            if (!integrationDefinition.isUsing()) {
                this.LOG.info((Object)("IntegrationDefinition(" + integrationDefinition + ") is not usagble"));
                continue;
            }
            if (!integrationDefinition.getProvider().isUsing()) {
                this.LOG.info((Object)("IntegrationDefinition(" + integrationDefinition + ")'s provider service is not usable"));
                continue;
            }
            WebServiceClientDefinition webServiceClientDefinition = this.webServiceClientDefinitionDao.getWebServiceClientDefinition(integrationDefinition.getProvider());
            if (webServiceClientDefinition == null) {
                this.LOG.error((Object)("WebServiceClientDefinition of IntegrationDefinition(" + integrationDefinition + ") does not exist."));
                continue;
            }
            if (!webServiceClientDefinition.isValid()) {
                this.LOG.error((Object)("WebServiceClientDefinition of IntegrationDefinition(" + integrationDefinition + ") is invalid"));
                continue;
            }
            this.LOG.debug((Object)("WebServiceClientDefinition = " + webServiceClientDefinition));
            RecordType requestType = null;
            try {
                requestType = (RecordType)this.typeLoader.getType(webServiceClientDefinition.getServiceDefinition().getRequestMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                this.LOG.error((Object)("RequestMessageType RecordType(id = \"" + webServiceClientDefinition.getServiceDefinition().getRequestMessageTypeId() + "\")'s definition does not exist."), (Throwable)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                this.LOG.error((Object)("RequestMessageType RecordType(id = \"" + webServiceClientDefinition.getServiceDefinition().getRequestMessageTypeId() + "\") has circular inheritance."), (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("RequestMesageType = " + requestType));
            RecordType responseType = null;
            try {
                responseType = (RecordType)this.typeLoader.getType(webServiceClientDefinition.getServiceDefinition().getResponseMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                this.LOG.error((Object)("ResponseMessageType RecordType(id = \"" + webServiceClientDefinition.getServiceDefinition().getResponseMessageTypeId() + "\")'s definition does not exist."), (Throwable)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                this.LOG.error((Object)("ResponseMessageType RecordType(id = \"" + webServiceClientDefinition.getServiceDefinition().getResponseMessageTypeId() + "\") has circular inheritance."), (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ResponseMessageType = " + responseType));
            ServiceEndpointInterfaceInfoImpl serviceEndpointInterfaceInfo = null;
            try {
                serviceEndpointInterfaceInfo = new ServiceEndpointInterfaceInfoImpl(webServiceClientDefinition, requestType, responseType);
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)"Cannot create ServiceEndpointInterfaceInfo", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("ServiceEndpointInterfaceInfo = " + serviceEndpointInterfaceInfo));
            EgovWebServiceClientImpl client = null;
            try {
                client = new EgovWebServiceClientImpl(this.classLoader, serviceEndpointInterfaceInfo, this.messageConverter);
            }
            catch (ClassNotFoundException e) {
                this.LOG.error((Object)"Cannot create EgovWebServiceClient", (Throwable)e);
                continue;
            }
            catch (MalformedURLException e) {
                this.LOG.error((Object)"Cannot create EgovWebServiceClient", (Throwable)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                this.LOG.error((Object)"Cannot create EgovWebServiceClient", (Throwable)e);
                continue;
            }
            catch (SecurityException e) {
                this.LOG.error((Object)"Cannot create EgovWebServiceClient", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("EgovWebServiceClient = " + client));
            EgovWebService service = null;
            try {
                service = new EgovWebService(integrationDefinition.getId(), this.defaultTimeout, integrationDefinition, client);
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)"Cannot create EgovWebService", (Throwable)e);
                continue;
            }
            this.LOG.debug((Object)("EgovWebService = " + (Object)((Object)service)));
            this.LOG.debug((Object)"Add Client Info");
            this.serviceMap.put(integrationDefinition.getId(), service);
        }
        this.LOG.debug((Object)"Finish initializing Client Info");
    }

    public void publishServer(Bus bus) {
        this.LOG.debug((Object)"Publish Server");
        this.bus = bus;
        BusFactory.setDefaultBus((Bus)bus);
        for (ServerInfo serverInfo : this.serverList) {
            this.LOG.debug((Object)("Publish Server (address = \"" + serverInfo.address + "\")"));
            try {
                Endpoint.publish((String)serverInfo.address, (Object)serverInfo.serviceImpl);
            }
            catch (Throwable e) {
                this.LOG.error((Object)("Fail in publishing Server (address = \"" + serverInfo.address + "\")"), e);
            }
        }
        this.LOG.debug((Object)"Finish publish Server");
    }

    public void attachMonitor(EgovIntegrationServiceMonitor monitor) {
    }

    public void detachMonitor(EgovIntegrationServiceMonitor monitor) {
    }

    public EgovIntegrationService getService(String id) {
        if (!this.serviceMap.containsKey(id)) {
            throw new EgovIntegrationNoSuchServiceException();
        }
        return (EgovIntegrationService)this.serviceMap.get(id);
    }

    protected static class ServerInfo {
        public String address;
        public Object serviceImpl;

        public ServerInfo(String address, Object serviceImpl) {
            this.address = address;
            this.serviceImpl = serviceImpl;
        }
    }
}

