/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.data;

import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

public class WebServiceServerDefinition
implements Validatable {
    private String key;
    private ServiceDefinition serviceDefinition;
    private String namespace;
    private String address;
    private String serviceName;
    private String portName;
    private String operationName;
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public WebServiceServerDefinition() {
    }

    public WebServiceServerDefinition(String key, ServiceDefinition serviceDefinition, String namespace, String address, String serviceName, String portName, String operationName) {
        this.key = key;
        this.serviceDefinition = serviceDefinition;
        this.namespace = namespace;
        this.address = address;
        this.serviceName = serviceName;
        this.portName = portName;
        this.operationName = operationName;
        this.statusChanged.set(true);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.statusChanged.set(true);
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setServiceDefinition(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
        this.statusChanged.set(true);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.statusChanged.set(true);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.statusChanged.set(true);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.statusChanged.set(true);
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
        this.statusChanged.set(true);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
        this.statusChanged.set(true);
    }

    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.key) && this.serviceDefinition != null && StringUtils.hasText((String)this.namespace) && StringUtils.hasText((String)this.address) && StringUtils.hasText((String)this.serviceName) && StringUtils.hasText((String)this.portName) && StringUtils.hasText((String)this.operationName);
            if (this.serviceDefinition != null) {
                this.valid = this.valid && this.serviceDefinition.isValid();
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tkey = ").append(StringUtils.quote((String)this.key)).append("\n\tserviceDefinition = ").append(this.serviceDefinition).append("\n\tnamespace = ").append(StringUtils.quote((String)this.namespace)).append("\n\taddress = ").append(StringUtils.quote((String)this.address)).append("\n\tserviceName = ").append(StringUtils.quote((String)this.serviceName)).append("\n\tportName = ").append(StringUtils.quote((String)this.portName)).append("\n\toperationName = ").append(StringUtils.quote((String)this.operationName)).append("\n}");
        return sb.toString();
    }
}

