/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class NumberRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 515;
    private int field_1_row;
    private int field_2_col;
    private int field_3_xf;
    private double field_4_value;

    public NumberRecord() {
    }

    public NumberRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readUShort();
        this.field_3_xf = in.readUShort();
        this.field_4_value = in.readDouble();
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public void setValue(double value) {
        this.field_4_value = value;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return (short)this.field_2_col;
    }

    public short getXFIndex() {
        return (short)this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[NUMBER]\n");
        sb.append("    .row    = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("    .col    = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("    .xfindex= ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        sb.append("    .value  = ").append(this.getValue()).append("\n");
        sb.append("[/NUMBER]\n");
        return sb.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putUShort(data, 0 + offset, 515);
        LittleEndian.putUShort(data, 2 + offset, 14);
        LittleEndian.putUShort(data, 4 + offset, this.getRow());
        LittleEndian.putUShort(data, 6 + offset, this.getColumn());
        LittleEndian.putUShort(data, 8 + offset, this.getXFIndex());
        LittleEndian.putDouble(data, 10 + offset, this.getValue());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 18;
    }

    public short getSid() {
        return 515;
    }

    public Object clone() {
        NumberRecord rec = new NumberRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_xf = this.field_3_xf;
        rec.field_4_value = this.field_4_value;
        return rec;
    }
}

