/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

public class RangeAddress {
    static final int WRONG_POS = -1;
    static final int MAX_HEIGHT = 66666;
    static final char SO_FORMNAME_ENCLOSURE = '\'';
    String m_sheetName;
    String m_cellFrom;
    String m_cellTo;

    public RangeAddress(String _url) {
        this.init(_url);
    }

    public RangeAddress(int _startCol, int _startRow, int _endCol, int _endRow) {
        this.init(this.numTo26Sys(_startCol) + _startRow + ":" + this.numTo26Sys(_endCol) + _endRow);
    }

    public String getAddress() {
        String result = "";
        if (this.m_sheetName != null) {
            result = result + this.m_sheetName + "!";
        }
        if (this.m_cellFrom != null) {
            result = result + this.m_cellFrom;
            if (this.m_cellTo != null) {
                result = result + ":" + this.m_cellTo;
            }
        }
        return result;
    }

    public String getSheetName() {
        return this.m_sheetName;
    }

    public String getRange() {
        String result = "";
        if (this.m_cellFrom != null) {
            result = result + this.m_cellFrom;
            if (this.m_cellTo != null) {
                result = result + ":" + this.m_cellTo;
            }
        }
        return result;
    }

    public boolean isCellOk(String _cell) {
        if (_cell != null) {
            return this.getYPosition(_cell) != -1 && this.getXPosition(_cell) != -1;
        }
        return false;
    }

    public boolean isSheetNameOk() {
        return RangeAddress.isSheetNameOk(this.m_sheetName);
    }

    private static boolean intern_isSheetNameOk(String _sheetName, boolean _canBeWaitSpace) {
        for (int i = 0; i < _sheetName.length(); ++i) {
            char ch = _sheetName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || _canBeWaitSpace && ch == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isSheetNameOk(String _sheetName) {
        boolean res = false;
        res = _sheetName != null && !_sheetName.equals("") ? RangeAddress.intern_isSheetNameOk(_sheetName, true) : true;
        return res;
    }

    public String getFromCell() {
        return this.m_cellFrom;
    }

    public String getToCell() {
        return this.m_cellTo;
    }

    public int getWidth() {
        if (this.m_cellFrom != null && this.m_cellTo != null) {
            int toX = this.getXPosition(this.m_cellTo);
            int fromX = this.getXPosition(this.m_cellFrom);
            if (toX == -1 || fromX == -1) {
                return 0;
            }
            return toX - fromX + 1;
        }
        return 0;
    }

    public int getHeight() {
        if (this.m_cellFrom != null && this.m_cellTo != null) {
            int toY = this.getYPosition(this.m_cellTo);
            int fromY = this.getYPosition(this.m_cellFrom);
            if (toY == -1 || fromY == -1) {
                return 0;
            }
            return toY - fromY + 1;
        }
        return 0;
    }

    public void setSize(int _width, int _height) {
        if (this.m_cellFrom == null) {
            this.m_cellFrom = "a1";
        }
        int tlX = this.getXPosition(this.m_cellFrom);
        int tlY = this.getYPosition(this.m_cellFrom);
        this.m_cellTo = this.numTo26Sys(tlX + _width - 1);
        this.m_cellTo = this.m_cellTo + String.valueOf(tlY + _height - 1);
    }

    public boolean hasSheetName() {
        return this.m_sheetName != null;
    }

    public boolean hasRange() {
        return this.m_cellFrom != null && this.m_cellTo != null && !this.m_cellFrom.equals(this.m_cellTo);
    }

    public boolean hasCell() {
        return this.m_cellFrom != null;
    }

    private void init(String _url) {
        _url = this.removeString(_url, "$");
        _url = this.removeString(_url, "'");
        String[] urls = this.parseURL(_url);
        this.m_sheetName = urls[0];
        this.m_cellFrom = urls[1];
        this.m_cellTo = urls[2];
        if (this.m_cellTo == null) {
            this.m_cellTo = this.m_cellFrom;
        }
        this.m_cellTo = this.removeString(this.m_cellTo, ".");
    }

    private String[] parseURL(String _url) {
        String[] result = new String[3];
        int index = _url.indexOf(58);
        if (index >= 0) {
            String fromStr = _url.substring(0, index);
            String toStr = _url.substring(index + 1);
            index = fromStr.indexOf(33);
            if (index >= 0) {
                result[0] = fromStr.substring(0, index);
                result[1] = fromStr.substring(index + 1);
            } else {
                result[1] = fromStr;
            }
            index = toStr.indexOf(33);
            result[2] = index >= 0 ? toStr.substring(index + 1) : toStr;
        } else {
            index = _url.indexOf(33);
            if (index >= 0) {
                result[0] = _url.substring(0, index);
                result[1] = _url.substring(index + 1);
            } else {
                result[1] = _url;
            }
        }
        return result;
    }

    public int getYPosition(String _subrange) {
        int result = -1;
        if ((_subrange = _subrange.trim()).length() != 0) {
            String digitstr = this.getDigitPart(_subrange);
            try {
                result = Integer.parseInt(digitstr);
                if (result > 66666) {
                    result = -1;
                }
            }
            catch (Exception ex) {
                result = -1;
            }
        }
        return result;
    }

    private static boolean isLetter(String _str) {
        boolean res = true;
        if (!_str.equals("")) {
            for (int i = 0; i < _str.length(); ++i) {
                char ch = _str.charAt(i);
                if (Character.isLetter(ch)) continue;
                res = false;
                break;
            }
        } else {
            res = false;
        }
        return res;
    }

    public int getXPosition(String _subrange) {
        int result = -1;
        String tmp = this.filter$(_subrange);
        tmp = this.getCharPart(_subrange);
        if (RangeAddress.isLetter(tmp) && (tmp.length() == 2 || tmp.length() == 1)) {
            result = this.get26Sys(tmp);
        }
        return result;
    }

    public String getDigitPart(String _value) {
        String result = "";
        int digitpos = this.getFirstDigitPosition(_value);
        if (digitpos >= 0) {
            result = _value.substring(digitpos);
        }
        return result;
    }

    public String getCharPart(String _value) {
        String result = "";
        int digitpos = this.getFirstDigitPosition(_value);
        if (digitpos >= 0) {
            result = _value.substring(0, digitpos);
        }
        return result;
    }

    private String filter$(String _range) {
        String res = "";
        for (int i = 0; i < _range.length(); ++i) {
            char ch = _range.charAt(i);
            if (ch == '$') continue;
            res = res + ch;
        }
        return res;
    }

    private int getFirstDigitPosition(String _value) {
        int result = -1;
        if (_value != null && _value.trim().length() == 0) {
            return result;
        }
        _value = _value.trim();
        int length = _value.length();
        for (int i = 0; i < length; ++i) {
            if (!Character.isDigit(_value.charAt(i))) continue;
            result = i;
            break;
        }
        return result;
    }

    public int get26Sys(String _s) {
        int sum = 0;
        int multiplier = 1;
        if (_s != "") {
            for (int i = _s.length() - 1; i >= 0; --i) {
                char ch = _s.charAt(i);
                int val = Character.getNumericValue(ch) - Character.getNumericValue('A') + 1;
                sum += val * multiplier;
                multiplier *= 26;
            }
            return sum;
        }
        return -1;
    }

    public String numTo26Sys(int _num) {
        boolean sum = false;
        String s = "";
        do {
            int reminder = --_num % 26;
            int val = 65 + reminder;
            s = (char)val + s;
        } while ((_num /= 26) > 0);
        return s;
    }

    public String replaceString(String _source, String _oldPattern, String _newPattern) {
        StringBuffer res = new StringBuffer(_source);
        int pos = -1;
        while ((pos = res.toString().indexOf(_oldPattern, pos)) > -1) {
            res.replace(pos, pos + _oldPattern.length(), _newPattern);
        }
        return res.toString();
    }

    public String removeString(String _source, String _match) {
        return this.replaceString(_source, _match, "");
    }
}

