/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalHandlerOutInterceptor<T extends Message>
extends AbstractJAXWSHandlerInterceptor<T> {
    public static final String ORIGINAL_WRITER = LogicalHandlerOutInterceptor.class.getName() + ".original_writer";
    private LogicalHandlerOutEndingInterceptor<T> ending;

    public LogicalHandlerOutInterceptor(Binding binding) {
        super(binding, "pre-marshal");
        this.ending = new LogicalHandlerOutEndingInterceptor(binding);
    }

    public void handleMessage(T message) throws Fault {
        HandlerChainInvoker invoker = this.getInvoker(message);
        if (invoker.getLogicalHandlers().isEmpty()) {
            return;
        }
        try {
            XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            Document document = XMLUtils.newDocument();
            message.setContent(Node.class, (Object)document);
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter(document);
            message.setContent(XMLStreamWriter.class, (Object)writer);
            message.put((Object)ORIGINAL_WRITER, (Object)origWriter);
            message.getInterceptorChain().add(this.ending);
        }
        catch (ParserConfigurationException e) {
            throw new Fault((Throwable)e);
        }
    }

    public void handleFault(T message) {
        super.handleFault(message);
        XMLStreamWriter os = (XMLStreamWriter)message.get((Object)ORIGINAL_WRITER);
        if (os != null) {
            message.setContent(XMLStreamWriter.class, (Object)os);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalHandlerOutEndingInterceptor<X extends Message>
    extends AbstractJAXWSHandlerInterceptor<X> {
        public LogicalHandlerOutEndingInterceptor(Binding binding) {
            super(binding, "post-marshal");
        }

        public void handleMessage(X message) throws Fault {
            W3CDOMStreamWriter domWriter = (W3CDOMStreamWriter)message.getContent(XMLStreamWriter.class);
            XMLStreamWriter origWriter = (XMLStreamWriter)message.get((Object)ORIGINAL_WRITER);
            HandlerChainInvoker invoker = this.getInvoker(message);
            LogicalMessageContextImpl lctx = new LogicalMessageContextImpl((Message)message);
            invoker.setLogicalMessageContext(lctx);
            boolean requestor = this.isRequestor((Message)message);
            XMLStreamReader reader = (XMLStreamReader)message.get((Object)"LogicalHandlerInterceptor.INREADER");
            SOAPMessage origMessage = null;
            if (reader != null) {
                origMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
                message.setContent(XMLStreamReader.class, (Object)reader);
                message.removeContent(SOAPMessage.class);
            } else if (domWriter.getDocument().getDocumentElement() != null) {
                DOMSource source = new DOMSource(domWriter.getDocument());
                message.setContent(Source.class, (Object)source);
                message.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Document)domWriter.getDocument()));
            }
            if (!invoker.invokeLogicalHandlers(requestor, lctx)) {
                if (requestor) {
                    message.getInterceptorChain().abort();
                    if (!message.getExchange().isOneWay()) {
                        Endpoint e = (Endpoint)message.getExchange().get(Endpoint.class);
                        Message responseMsg = e.getBinding().createMessage();
                        MessageObserver observer = (MessageObserver)message.getExchange().get(MessageObserver.class);
                        if (observer != null) {
                            responseMsg.setContent(XMLStreamReader.class, message.getContent(XMLStreamReader.class));
                            message.getExchange().setInMessage(responseMsg);
                            responseMsg.put((Object)"starting_at_interceptor_id", (Object)LogicalHandlerInInterceptor.class.getName());
                            observer.onMessage(responseMsg);
                        }
                    }
                }
                return;
            }
            if (origMessage != null) {
                message.setContent(SOAPMessage.class, (Object)origMessage);
            }
            try {
                reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
                message.removeContent(XMLStreamReader.class);
                if (reader != null) {
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)origWriter);
                } else if (domWriter.getDocument().getDocumentElement() != null) {
                    StaxUtils.copy((Document)domWriter.getDocument(), (XMLStreamWriter)origWriter);
                }
                message.setContent(XMLStreamWriter.class, (Object)origWriter);
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
        }
    }
}

