/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.predicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.predicates.ValidationRule;

public class BasicValidationRule
implements ValidationRule {
    private Predicate predicate = null;
    private String field = null;
    private String errorMessage = null;
    private String errorKey = null;
    private Collection errorArgs = null;

    public BasicValidationRule(String field, Predicate predicate, String errorMessage) {
        this.setField(field);
        this.setPredicate(predicate);
        this.setErrorMessage(errorMessage);
    }

    public BasicValidationRule(String field, Predicate predicate, String errorKey, String errorMessage, Collection errorArgs) {
        this(field, predicate, errorMessage);
        this.setErrorKey(errorKey);
        this.setErrorArgs(errorArgs);
    }

    private void setPredicate(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate parameter must not be null!");
        }
        this.predicate = predicate;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    private void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("Error message parameter must not be null!");
        }
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void setField(String field) {
        if (field == null) {
            throw new IllegalArgumentException("Field parameter must not be null!");
        }
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    private void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    private void setErrorArgs(Collection errorArgs) {
        this.errorArgs = errorArgs;
    }

    public Collection getErrorArgs() {
        return this.errorArgs;
    }

    public void validate(Object target, Errors errors) {
        Object tmpTarget = target instanceof BeanWrapper || target instanceof Map ? target : new BeanWrapperImpl(target);
        if (!this.getPredicate().evaluate(tmpTarget)) {
            if (StringUtils.hasLength((String)this.getErrorKey())) {
                if (this.getErrorArgs() != null && !this.getErrorArgs().isEmpty()) {
                    ArrayList<Object> tmpColl = new ArrayList<Object>();
                    Iterator iter = this.getErrorArgs().iterator();
                    while (iter.hasNext()) {
                        tmpColl.add(((Function)iter.next()).getResult(tmpTarget));
                    }
                    errors.rejectValue(this.getField(), this.getErrorKey(), tmpColl.toArray(), this.getErrorMessage());
                } else {
                    errors.rejectValue(this.getField(), this.getErrorKey(), this.getErrorMessage());
                }
            } else {
                errors.rejectValue(this.getField(), this.getField(), this.getErrorMessage());
            }
        }
    }
}

