/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TbDatabaseMetaData
implements DatabaseMetaData {
    private static String DRIVER_NAME = "Tibero JDBC driver";
    private static String DRIVER_VERSION = "3.0.0";
    private static int DRIVER_MAJOR_VERSION = 3;
    private static int DRIVER_MINOR_VERSION = 0;
    protected TbConnection _connection;

    public TbDatabaseMetaData(TbConnection conn) {
        this._connection = conn;
    }

    public String getServerCharSet() throws SQLException {
        String[] charSet = new String[]{"ISO-8859-1", "EUC-KR", "MS949", "UTF-8"};
        return charSet[this._connection.getServerCharSet()];
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        return this._connection.info.getUrl();
    }

    public String getUserName() throws SQLException {
        return this._connection.info.getUser();
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return this._connection.serverInfo.getTbProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this._connection.serverInfo.getTbProductVersion();
    }

    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    public int getDriverMajorVersion() {
        return DRIVER_MAJOR_VERSION;
    }

    public int getDriverMinorVersion() {
        return DRIVER_MINOR_VERSION;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,LCASE,LENGTH,LTRIM,REPLACE,RTRIM,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        return "USER";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "HOUR,MINUTE,SECOND,MONTH,YEAR";
    }

    public String getSearchStringEscape() throws SQLException {
        return "//";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$#";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 65535;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 65535;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 30;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 255;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 30;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 30;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 30;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 30;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public synchronized ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String tmpSchemaPattern = schemaPattern == null ? "%" : (schemaPattern.equals("") ? this._connection.info.getUser() : schemaPattern);
        StringBuffer sql = new StringBuffer();
        if (catalog == null) {
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES01);
            sql.append(" UNION ALL");
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES02);
            sql.append(" AND package_name IS NOT NULL ");
            sql.append(" AND owner LIKE ? ESCAPE '/' ");
            sql.append(" AND object_name LIKE ? ESCAPE '/' ");
            sql.append(" UNION ALL ");
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES03);
            sql.append(" AND package_name IS NOT NULL ");
            sql.append(" AND owner LIKE ? ESCAPE '/' ");
            sql.append(" AND object_name LIKE ? ESCAPE '/' ");
            sql.append(" UNION ALL");
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES04);
            sql.append(" AND package_name IS NOT NULL ");
            sql.append(" AND owner LIKE ? ESCAPE '/' ");
            sql.append(" AND object_name LIKE ? ESCAPE '/' ");
            sql.append(" ORDER BY procedure_schem, procedure_name ");
        } else if (catalog.equals("")) {
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES01);
        } else {
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES02);
            sql.append(" AND package_name LIKE ? ESCAPE '/' ");
            sql.append(" AND owner LIKE ? ESCAPE '/' ");
            sql.append(" AND object_name LIKE ? ESCAPE '/' ");
            sql.append(" UNION ALL");
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES03);
            sql.append(" AND package_name LIKE ? ESCAPE '/' ");
            sql.append(" AND owner LIKE ? ESCAPE '/' ");
            sql.append(" AND object_name LIKE ? ESCAPE '/' ");
            sql.append(" UNION ALL");
            sql.append(TbDatabaseMetaQuery.QUERY_PROCEDURES04);
            sql.append(" AND package_name LIKE ? ESCAPE '/' ");
            sql.append(" AND owner LIKE ? ESCAPE '/' ");
            sql.append(" AND object_name LIKE ? ESCAPE '/' ");
            sql.append(" ORDER BY procedure_schem, procedure_name");
        }
        PreparedStatement pstmt = this._connection.prepareStatement(sql.substring(0, sql.length()));
        if (catalog == null) {
            pstmt.setString(1, tmpSchemaPattern);
            pstmt.setString(2, procedureNamePattern);
            pstmt.setString(3, tmpSchemaPattern);
            pstmt.setString(4, procedureNamePattern);
            pstmt.setString(5, tmpSchemaPattern);
            pstmt.setString(6, procedureNamePattern);
            pstmt.setString(7, tmpSchemaPattern);
            pstmt.setString(8, procedureNamePattern);
        } else if (catalog.equals("")) {
            pstmt.setString(1, tmpSchemaPattern);
            pstmt.setString(2, procedureNamePattern);
        } else {
            pstmt.setString(1, catalog);
            pstmt.setString(2, tmpSchemaPattern);
            pstmt.setString(3, procedureNamePattern);
            pstmt.setString(4, catalog);
            pstmt.setString(5, tmpSchemaPattern);
            pstmt.setString(6, procedureNamePattern);
            pstmt.setString(7, catalog);
            pstmt.setString(8, tmpSchemaPattern);
            pstmt.setString(9, procedureNamePattern);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_PROCEDURE_COLUMNS);
        if (catalog != null && catalog.equals("")) {
            sql.append(" AND package_name IS NULL");
        } else if (catalog != null) {
            sql.append(" AND package_name LIKE ? ESCAPE '/' ");
        }
        sql.append(" AND argument_name LIKE ? ESCAPE '/' ");
        sql.append(" ORDER BY procedure_schem, procedure_name ");
        PreparedStatement pstmt = this._connection.prepareStatement(sql.substring(0, sql.length()));
        int i = 1;
        if (schemaPattern == null) {
            pstmt.setString(i++, "%");
        } else if (schemaPattern.equals("")) {
            pstmt.setString(i++, this._connection.info.getUser());
        } else {
            pstmt.setString(i++, schemaPattern);
        }
        pstmt.setString(i++, procedureNamePattern);
        if (catalog != null && !catalog.equals("")) {
            pstmt.setString(i++, catalog);
        }
        pstmt.setString(i++, columnNamePattern);
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_TABLES);
        if (types != null) {
            sql.append(" AND o.object_type IN ( ");
            for (int i = 0; i < types.length; ++i) {
                if (i == 0) {
                    sql.append("'").append(types[i]).append("'");
                    continue;
                }
                sql.append(", '").append(types[i]).append("'");
            }
            sql.append(") ");
        } else {
            sql.append(" AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW') ");
        }
        PreparedStatement pstmt = this._connection.prepareStatement(sql.substring(0, sql.length()));
        pstmt.setString(1, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(2, tableNamePattern != null ? tableNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this._connection.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_SCHEMAS);
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getCatalogs() throws SQLException {
        Statement stmt = this._connection.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_CATALOGS);
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getTableTypes() throws SQLException {
        Statement stmt = this._connection.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_TABLETYPES);
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        PreparedStatement pstmt = this._connection.prepareStatement(TbDatabaseMetaQuery.QUERY_COLUMNS);
        pstmt.setString(1, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(2, tableNamePattern != null ? tableNamePattern : "%");
        pstmt.setString(3, columnNamePattern != null ? columnNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        PreparedStatement pstmt = this._connection.prepareStatement(TbDatabaseMetaQuery.QUERY_COLUMNPRIVILEGES);
        pstmt.setString(1, schema != null ? schema : "%");
        pstmt.setString(2, table != null ? table : "%");
        pstmt.setString(3, columnNamePattern != null ? columnNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement pstmt = this._connection.prepareStatement(TbDatabaseMetaQuery.QUERY_TABLEPRIVILEGES);
        pstmt.setString(1, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(2, tableNamePattern != null ? tableNamePattern : "%");
        pstmt.setString(3, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(4, tableNamePattern != null ? tableNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        PreparedStatement pstmt = this._connection.prepareStatement(TbDatabaseMetaQuery.QUERY_BESTROWIDENTIFIER);
        switch (scope) {
            case 0: {
                pstmt.setInt(1, 0);
                pstmt.setInt(2, 0);
                break;
            }
            case 1: {
                pstmt.setInt(1, 1);
                pstmt.setInt(2, 1);
                break;
            }
            case 2: {
                pstmt.setInt(1, 0);
                pstmt.setInt(2, 1);
            }
        }
        pstmt.setString(3, table);
        pstmt.setString(4, schema != null ? schema : "%");
        pstmt.setString(5, nullable ? "X" : "Y");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement pstmt = this._connection.prepareStatement(TbDatabaseMetaQuery.QUERY_PRIMARYKEY);
        pstmt.setString(1, table);
        pstmt.setString(2, schema != null ? schema : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRelatedKeys(null, null, schema, table, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRelatedKeys(schema, table, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getRelatedKeys(primarySchema, primaryTable, foreignSchema, foreignTable, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public ResultSet getTypeInfo() throws SQLException {
        Statement stmt = this._connection.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_TYPEINFO);
        rsb.closeStatementOnClose();
        return rsb;
    }

    public synchronized ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        CallableStatement cstmt = this._connection.prepareCall(TbDatabaseMetaQuery.QUERY_GATHER_TABLE_STATS);
        cstmt.setString(1, schema != null && schema.length() > 0 ? schema : this._connection.info.getUser());
        cstmt.setString(2, table);
        cstmt.execute();
        cstmt.close();
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_INDEXINFO01);
        if (schema != null && schema.length() > 0) {
            sql.append(" and owner = ? ");
        }
        sql.append(" union ");
        sql.append(TbDatabaseMetaQuery.QUERY_INDEXINFO02);
        if (schema != null && schema.length() > 0) {
            sql.append(" and i.owner = ? ");
        }
        if (unique) {
            sql.append(" and i.uniqueness = 'UNIQUE' ");
        }
        sql.append(TbDatabaseMetaQuery.QUERY_INDEXINFO03);
        PreparedStatement pstmt = this._connection.prepareStatement(sql.substring(0, sql.length()));
        int i = 1;
        pstmt.setString(i++, table);
        if (schema != null && schema.length() > 0) {
            pstmt.setString(i++, schema);
        }
        pstmt.setString(i++, table);
        if (schema != null && schema.length() > 0) {
            pstmt.setString(i++, schema);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
            case 1005: {
                return false;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (concurrency == 1008) {
            return false;
        }
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
            case 1005: {
                return false;
            }
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int i) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int i) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Connection getConnection() throws SQLException {
        return this._connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this._connection.serverInfo.getTbMajor();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this._connection.serverInfo.getTbMinor();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return DRIVER_MAJOR_VERSION;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return DRIVER_MINOR_VERSION;
    }

    public int getSQLStateType() throws SQLException {
        return 0;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public synchronized ResultSet getDBParam(String paramName) throws SQLException {
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_IPARAM);
        if (paramName != null) {
            sql.append(" name like '%" + paramName.toUpperCase() + "%' and");
        }
        sql.append(" name not like '\\_%' escape '\\'");
        PreparedStatement pstmt = this._connection.prepareStatement(sql.toString());
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    private synchronized ResultSet getRelatedKeys(String primarySchema, String primaryTable, String foreignSchema, String foreignTable, String orderByClause) throws SQLException {
        int i = 1;
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_RELATEDKEYS);
        if (primaryTable != null) {
            sql.append(" AND p.table_name \t= ? ");
        }
        if (foreignTable != null) {
            sql.append(" AND f.table_name \t= ? ");
        }
        if (primarySchema != null && primarySchema.length() > 0) {
            sql.append(" AND p.owner \t= ? ");
        }
        if (foreignSchema != null && foreignSchema.length() > 0) {
            sql.append(" AND f.owner \t= ? ");
        }
        sql.append(orderByClause);
        PreparedStatement pstmt = this._connection.prepareStatement(sql.substring(0, sql.length()));
        if (primaryTable != null) {
            pstmt.setString(i++, primaryTable);
        }
        if (foreignTable != null) {
            pstmt.setString(i++, foreignTable);
        }
        if (primarySchema != null && primarySchema.length() > 0) {
            pstmt.setString(i++, primarySchema);
        }
        if (foreignSchema != null && foreignSchema.length() > 0) {
            pstmt.setString(i++, foreignSchema);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }
}

