/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbStreamDataWriter {
    protected StreamBuffer buf;
    private DataTypeConverter typeConverter = null;

    public TbStreamDataWriter(StreamBuffer buf, DataTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.initialize(buf);
    }

    public TbStreamDataWriter(StreamBuffer buf) {
        this(buf, null);
    }

    public void initialize(StreamBuffer buf) {
        buf.init();
        this.buf = buf;
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.remove();
            this.buf = null;
        }
        this.typeConverter = null;
    }

    public int getBufferedDataSize() {
        if (this.buf != null) {
            return this.buf.getCurDataSize();
        }
        return 0;
    }

    public StreamBuffer getStreamBuf() {
        return this.buf;
    }

    public int writeInt(int num, int byteLen) throws SQLException {
        this.buf.makeBufferAvailable(byteLen);
        TbCommon.int2bytes(num, this.buf.getRawBytes(), this.buf.getCurDataSize(), byteLen);
        this.buf.addDataSize(byteLen);
        return byteLen;
    }

    public int reWriteInt(int bufOffset, int newVal, int byteLen) throws SQLException {
        TbCommon.int2bytes(newVal, this.buf.getRawBytes(), bufOffset, byteLen);
        return byteLen;
    }

    public int writeLong(long num, int byteLen) throws SQLException {
        this.buf.makeBufferAvailable(byteLen);
        TbCommon.long2bytes(num, this.buf.getRawBytes(), this.buf.getCurDataSize(), byteLen);
        this.buf.addDataSize(byteLen);
        return byteLen;
    }

    public int reWriteLong(int bufOffset, long newVal, int byteLen) throws SQLException {
        TbCommon.long2bytes(newVal, this.buf.getRawBytes(), bufOffset, byteLen);
        return byteLen;
    }

    public int writeBytes(byte[] bytes) throws SQLException {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public int writeBytes(byte[] bytes, int offset, int len) {
        this.buf.copyRowData(len, offset, bytes);
        return len;
    }

    public int writePadBytes(byte[] bytes) throws SQLException {
        return this.writePadBytes(bytes, 0, bytes.length);
    }

    public int writePadBytes(byte[] col, int rpcolLen, byte[] dataValue, int dataLen) throws SQLException {
        this.writeBytes(col, 0, rpcolLen);
        this.writeBytes(dataValue, 0, dataLen);
        int padLen = this.writePadding(rpcolLen + dataLen);
        return rpcolLen + dataLen + padLen;
    }

    public int writePadBytes(byte[] bytes, int offset, int len) {
        this.writeBytes(bytes, offset, len);
        int padLen = this.writePadding(len);
        return len + padLen;
    }

    public int writeLenAndDBEncodedPadString(String str) throws SQLException {
        byte[] bytes = this.typeConverter.getDBEncodedBytes(str);
        int len = bytes.length;
        this.writeInt(len, 4);
        this.buf.copyRowData(len, 0, bytes);
        int padLen = this.writePadding(len);
        return len + padLen + 4;
    }

    public int writeCharsToBytes(char[] charArray, long bufOffset, long numChar) throws SQLException {
        int byteLen = 0;
        int maxLen = this.typeConverter.getMaxBytesPerChar() * (int)numChar;
        this.buf.makeBufferAvailable(maxLen);
        byteLen = this.typeConverter.charsToBytes(charArray, (int)bufOffset, (int)numChar, this.buf.getRawBytes(), this.buf.getCurDataSize(), this.buf.getRemained());
        this.buf.addDataSize(byteLen);
        return byteLen;
    }

    public int writeCharsToPadBytes(char[] charArray, long bufOffset, long numChar) throws SQLException {
        int writeLen = this.writeCharsToBytes(charArray, bufOffset, numChar);
        int padLen = this.writePadding(writeLen);
        return writeLen + padLen;
    }

    public int writeCharsToFixedBytes(char[] charArray, long bufOffset, long numChar) throws SQLException {
        int byteLen = 0;
        int maxLen = this.typeConverter.getUCS2MaxBytesPerChar() * (int)numChar;
        this.buf.makeBufferAvailable(maxLen);
        byteLen = this.typeConverter.charsToFixedBytes(charArray, (int)bufOffset, (int)numChar, this.buf.getRawBytes(), this.buf.getCurDataSize(), this.buf.getRemained());
        this.buf.addDataSize(byteLen);
        return byteLen;
    }

    public int writeCharsToPadFixedBytes(char[] charArray, long bufOffset, long numChar) throws SQLException {
        int writeLen = this.writeCharsToFixedBytes(charArray, bufOffset, numChar);
        int padLen = this.writePadding(writeLen);
        return writeLen + padLen;
    }

    public int writeLenAndCharsToPadFixedBytes(char[] charArray, long bufOffset, long numChar) throws SQLException {
        this.writeInt((int)numChar * this.typeConverter.getUCS2MaxBytesPerChar(), 4);
        int writeLen = this.writeCharsToFixedBytes(charArray, bufOffset, numChar);
        int padLen = this.writePadding(writeLen);
        return 4 + writeLen + padLen;
    }

    public int writeLobLocator(byte[] locator) throws SQLException {
        if (locator == null || locator[0] != 0 || locator[1] <= 50 || locator[1] >= 100) {
            throw new TbSQLException(-590715);
        }
        this.writeInt(locator.length, 4);
        this.writeBytes(locator);
        return 4 + locator.length;
    }

    protected int writePadding(int len) {
        int padLen = TbCommon.getPadLength(len);
        this.putPadding(padLen);
        return padLen;
    }

    public int putPadding(int paddingLen) {
        this.buf.putData(paddingLen, (byte)0);
        return paddingLen;
    }

    public void setCurDataSize(int dataSize) {
        this.buf.setCurDataSize(dataSize);
    }

    public int writeRpcolData(byte[] data, int len) throws SQLException {
        int rpcolLen;
        byte[] col = new byte[3];
        if (len <= 250) {
            col[0] = (byte)len;
            rpcolLen = 1;
        } else {
            col[0] = -2;
            col[1] = (byte)(0xFF & len >> 8);
            col[2] = (byte)(0xFF & len);
            rpcolLen = 3;
        }
        if (len != 0) {
            return this.writePadBytes(col, rpcolLen, data, len);
        }
        byte[] nullData = new byte[]{0};
        return this.writePadBytes(col, rpcolLen, nullData, 1);
    }
}

